/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.frame.DataAndMetadataFlyweight;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;

public class KeepAliveFrameFlyweight {
    public static final int FLAGS_KEEPALIVE_R = 128;
    public static final long LAST_POSITION_MASK = Long.MIN_VALUE;

    private KeepAliveFrameFlyweight() {
    }

    public static ByteBuf encode(ByteBufAllocator allocator, boolean respond, long lastPosition, ByteBuf data) {
        int flags = respond ? 128 : 0;
        ByteBuf header = FrameHeaderFlyweight.encodeStreamZero(allocator, FrameType.KEEPALIVE, flags);
        long lp = 0L;
        if (lastPosition > 0L) {
            lp |= lastPosition;
        }
        header.writeLong(lp);
        return DataAndMetadataFlyweight.encode(allocator, header, null, false, data);
    }

    public static boolean respondFlag(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.KEEPALIVE, byteBuf);
        int flags = FrameHeaderFlyweight.flags(byteBuf);
        return (flags & 0x80) == 128;
    }

    public static long lastPosition(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.KEEPALIVE, byteBuf);
        byteBuf.markReaderIndex();
        long l = byteBuf.skipBytes(FrameHeaderFlyweight.size()).readLong();
        byteBuf.resetReaderIndex();
        return l;
    }

    public static ByteBuf data(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.KEEPALIVE, byteBuf);
        byteBuf.markReaderIndex();
        ByteBuf slice = byteBuf.skipBytes(FrameHeaderFlyweight.size() + 8).slice();
        byteBuf.resetReaderIndex();
        return slice;
    }
}

