/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.rsocket.util.MonoLifecycleHandler;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalType;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public class UnicastMonoProcessor<O>
extends Mono<O>
implements Processor<O, O>,
CoreSubscriber<O>,
Disposable,
Subscription,
Scannable {
    static final MonoLifecycleHandler DEFAULT_LIFECYCLE = new MonoLifecycleHandler(){};
    static final int NO_SUBSCRIBER_NO_RESULT = 0;
    static final int NO_SUBSCRIBER_HAS_RESULT = 1;
    static final int NO_REQUEST_NO_RESULT = 4;
    static final int NO_REQUEST_HAS_RESULT = 5;
    static final int HAS_REQUEST_NO_RESULT = 6;
    static final int HAS_REQUEST_HAS_RESULT = 7;
    static final int CANCELLED = 8;
    volatile int state;
    static final AtomicIntegerFieldUpdater<UnicastMonoProcessor> STATE = AtomicIntegerFieldUpdater.newUpdater(UnicastMonoProcessor.class, "state");
    volatile int once;
    static final AtomicIntegerFieldUpdater<UnicastMonoProcessor> ONCE = AtomicIntegerFieldUpdater.newUpdater(UnicastMonoProcessor.class, "once");
    volatile Subscription subscription;
    static final AtomicReferenceFieldUpdater<UnicastMonoProcessor, Subscription> UPSTREAM = AtomicReferenceFieldUpdater.newUpdater(UnicastMonoProcessor.class, Subscription.class, "subscription");
    CoreSubscriber<? super O> actual;
    Throwable error;
    O value;
    final MonoLifecycleHandler<O> lifecycleHandler;

    public static <T> UnicastMonoProcessor<T> create() {
        return new UnicastMonoProcessor(DEFAULT_LIFECYCLE);
    }

    public static <T> UnicastMonoProcessor<T> create(MonoLifecycleHandler<T> lifecycleHandler) {
        return new UnicastMonoProcessor<T>(lifecycleHandler);
    }

    UnicastMonoProcessor(MonoLifecycleHandler<O> lifecycleHandler) {
        this.lifecycleHandler = lifecycleHandler;
    }

    @NonNull
    public Context currentContext() {
        CoreSubscriber<? super O> a = this.actual;
        return a != null ? a.currentContext() : Context.empty();
    }

    public final void onSubscribe(Subscription subscription) {
        if (Operators.setOnce(UPSTREAM, (Object)((Object)this), (Subscription)subscription)) {
            subscription.request(Long.MAX_VALUE);
        }
    }

    public final void onComplete() {
        this.onNext(null);
    }

    public final void onError(Throwable cause) {
        Objects.requireNonNull(cause, "onError cannot be null");
        if (UPSTREAM.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            Operators.onErrorDropped((Throwable)cause, (Context)this.currentContext());
            return;
        }
        this.complete(cause);
    }

    public final void onNext(@Nullable O value) {
        Subscription s = UPSTREAM.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            if (value != null) {
                Operators.onNextDropped(value, (Context)this.currentContext());
            }
            return;
        }
        if (value == null) {
            this.complete();
        } else {
            if (s != null) {
                s.cancel();
            }
            this.complete(value);
        }
    }

    private void complete(O v) {
        int state;
        do {
            if (((state = this.state) & 0xFFFFFFF9) != 0) {
                this.value = null;
                Operators.onDiscard(v, (Context)this.currentContext());
                return;
            }
            if (state == 6 && STATE.compareAndSet(this, 6, 7)) {
                CoreSubscriber<? super O> a = this.actual;
                this.actual = null;
                this.value = null;
                this.lifecycleHandler.doOnTerminal(SignalType.ON_COMPLETE, v, null);
                a.onNext(v);
                a.onComplete();
                return;
            }
            this.setValue(v);
            if (state != 4 || !STATE.compareAndSet(this, 4, 5)) continue;
            return;
        } while (state != 0 || !STATE.compareAndSet(this, 0, 1));
    }

    private void complete() {
        int state;
        do {
            if (((state = this.state) & 0xFFFFFFF9) != 0) {
                return;
            }
            if (state != 6 && state != 4 || !STATE.compareAndSet(this, state, 7)) continue;
            CoreSubscriber<? super O> a = this.actual;
            this.actual = null;
            this.lifecycleHandler.doOnTerminal(SignalType.ON_COMPLETE, null, null);
            a.onComplete();
            return;
        } while (state != 0 || !STATE.compareAndSet(this, 0, 1));
    }

    private void complete(Throwable e) {
        int state;
        do {
            if (((state = this.state) & 0xFFFFFFF9) != 0) {
                return;
            }
            this.setError(e);
            if (state != 6 && state != 4 || !STATE.compareAndSet(this, state, 7)) continue;
            CoreSubscriber<? super O> a = this.actual;
            this.actual = null;
            this.lifecycleHandler.doOnTerminal(SignalType.ON_ERROR, null, e);
            a.onError(e);
            return;
        } while (state != 0 || !STATE.compareAndSet(this, 0, 1));
    }

    public void subscribe(CoreSubscriber<? super O> actual) {
        Objects.requireNonNull(actual, "subscribe");
        if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
            MonoLifecycleHandler<O> lh = this.lifecycleHandler;
            lh.doOnSubscribe();
            this.actual = actual;
            int state = this.state;
            if (state == 0) {
                if (STATE.compareAndSet(this, 0, 4)) {
                    state = 4;
                } else {
                    STATE.set(this, 5);
                    state = 5;
                }
            } else {
                STATE.set(this, 5);
                state = 5;
            }
            if (state == 5 && this.value == null) {
                this.actual = null;
                Throwable e = this.error;
                STATE.set(this, 7);
                if (e == null) {
                    lh.doOnTerminal(SignalType.ON_COMPLETE, null, null);
                    Operators.complete(actual);
                } else {
                    lh.doOnTerminal(SignalType.ON_ERROR, null, e);
                    Operators.error(actual, (Throwable)e);
                }
                return;
            }
            actual.onSubscribe((Subscription)this);
        } else {
            Operators.error(actual, (Throwable)new IllegalStateException("UnicastMonoProcessor allows only a single Subscriber"));
        }
    }

    public final void request(long n) {
        if (Operators.validate((long)n)) {
            do {
                int s;
                if (((s = this.state) & 0xFFFFFFFA) != 0) {
                    return;
                }
                if (s != 5 || !STATE.compareAndSet(this, 5, 7)) continue;
                CoreSubscriber<? super O> a = this.actual;
                O v = this.value;
                this.actual = null;
                this.value = null;
                this.lifecycleHandler.doOnTerminal(SignalType.ON_COMPLETE, v, null);
                a.onNext(v);
                a.onComplete();
                return;
            } while (!STATE.compareAndSet(this, 4, 6));
            return;
        }
    }

    public final void cancel() {
        if (STATE.getAndSet(this, 8) <= 6) {
            Operators.onDiscard(this.value, (Context)this.currentContext());
            this.value = null;
            this.actual = null;
            this.lifecycleHandler.doOnTerminal(SignalType.CANCEL, null, null);
            Subscription s = UPSTREAM.getAndSet(this, Operators.cancelledSubscription());
            if (s != null && s != Operators.cancelledSubscription()) {
                s.cancel();
            }
        }
    }

    public void dispose() {
        Subscription s = UPSTREAM.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            return;
        }
        if (s != null) {
            s.cancel();
        }
        this.complete(new CancellationException("Disposed"));
    }

    @Nullable
    public O peek() {
        if (this.isCancelled()) {
            return null;
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.error != null) {
            RuntimeException re = Exceptions.propagate((Throwable)this.error);
            re = Exceptions.addSuppressed((RuntimeException)re, (Throwable)new Exception("Mono#peek terminated with an error"));
            throw re;
        }
        return null;
    }

    private void setValue(O value) {
        this.value = value;
    }

    private void setError(Throwable throwable) {
        this.error = throwable;
    }

    @Nullable
    public final Throwable getError() {
        return this.isDisposed() ? this.error : null;
    }

    public final boolean isError() {
        return this.getError() != null;
    }

    public boolean isCancelled() {
        return this.state == 8;
    }

    public final boolean isTerminated() {
        int state = this.state;
        return state < 8 && state % 2 == 1;
    }

    public boolean isDisposed() {
        int state = this.state;
        return state == 8 || state < 8 && state % 2 == 1;
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        int state = this.state;
        if (key == Scannable.Attr.TERMINATED) {
            return state < 8 && state % 2 == 1;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.subscription;
        }
        if (key == Scannable.Attr.ERROR) {
            return this.error;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return Integer.MAX_VALUE;
        }
        if (key == Scannable.Attr.CANCELLED) {
            return state == 8;
        }
        return null;
    }

    public final boolean hasDownstream() {
        return this.state > 1 && this.actual != null;
    }
}

