/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

public class RateLimitableRequestPublisher<T>
extends Flux<T>
implements Subscription {
    private static final int NOT_CANCELED_STATE = 0;
    private static final int CANCELED_STATE = 1;
    private final Publisher<T> source;
    private volatile int canceled;
    private static final AtomicIntegerFieldUpdater<RateLimitableRequestPublisher> CANCELED = AtomicIntegerFieldUpdater.newUpdater(RateLimitableRequestPublisher.class, "canceled");
    private final long prefetch;
    private final long limit;
    private long externalRequested;
    private int pendingToFulfil;
    private int deliveredElements;
    private boolean subscribed;
    @Nullable
    private Subscription internalSubscription;

    private RateLimitableRequestPublisher(Publisher<T> source, long prefetch) {
        this.source = source;
        this.prefetch = prefetch;
        this.limit = prefetch == Integer.MAX_VALUE ? Integer.MAX_VALUE : prefetch - (prefetch >> 2);
    }

    public static <T> RateLimitableRequestPublisher<T> wrap(Publisher<T> source, long prefetch) {
        return new RateLimitableRequestPublisher<T>(source, prefetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(CoreSubscriber<? super T> destination) {
        RateLimitableRequestPublisher rateLimitableRequestPublisher = this;
        synchronized (rateLimitableRequestPublisher) {
            if (this.subscribed) {
                throw new IllegalStateException("only one subscriber at a time");
            }
            this.subscribed = true;
        }
        InnerOperator s = new InnerOperator((Subscriber)destination);
        this.source.subscribe((Subscriber)s);
        destination.onSubscribe((Subscription)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        RateLimitableRequestPublisher rateLimitableRequestPublisher = this;
        synchronized (rateLimitableRequestPublisher) {
            long requested = this.externalRequested;
            if (requested == Long.MAX_VALUE) {
                return;
            }
            this.externalRequested = Operators.addCap((long)n, (long)requested);
        }
        this.requestN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestN() {
        long r;
        Subscription s;
        RateLimitableRequestPublisher rateLimitableRequestPublisher = this;
        synchronized (rateLimitableRequestPublisher) {
            s = this.internalSubscription;
            if (s == null) {
                return;
            }
            long er = this.externalRequested;
            long p = this.prefetch;
            int pendingFulfil = this.pendingToFulfil;
            if (er != Long.MAX_VALUE || p != Integer.MAX_VALUE) {
                if ((long)pendingFulfil == p) {
                    return;
                }
                r = Math.min(p - (long)pendingFulfil, er);
                if (er != Long.MAX_VALUE) {
                    this.externalRequested -= r;
                }
                if (p != Integer.MAX_VALUE) {
                    this.pendingToFulfil = (int)((long)this.pendingToFulfil + r);
                }
            } else {
                r = Long.MAX_VALUE;
            }
        }
        if (r > 0L) {
            s.request(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.isCanceled() && CANCELED.compareAndSet(this, 0, 1)) {
            Subscription s;
            RateLimitableRequestPublisher rateLimitableRequestPublisher = this;
            synchronized (rateLimitableRequestPublisher) {
                s = this.internalSubscription;
                this.internalSubscription = null;
                this.subscribed = false;
            }
            if (s != null) {
                s.cancel();
            }
        }
    }

    private boolean isCanceled() {
        return this.canceled == 1;
    }

    private class InnerOperator
    implements CoreSubscriber<T>,
    Subscription {
        final Subscriber<? super T> destination;

        private InnerOperator(Subscriber<? super T> destination) {
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSubscribe(Subscription s) {
            RateLimitableRequestPublisher rateLimitableRequestPublisher = RateLimitableRequestPublisher.this;
            synchronized (rateLimitableRequestPublisher) {
                RateLimitableRequestPublisher.this.internalSubscription = s;
                if (RateLimitableRequestPublisher.this.isCanceled()) {
                    s.cancel();
                    RateLimitableRequestPublisher.this.subscribed = false;
                    RateLimitableRequestPublisher.this.internalSubscription = null;
                }
            }
            RateLimitableRequestPublisher.this.requestN();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            try {
                this.destination.onNext(t);
                if (RateLimitableRequestPublisher.this.prefetch == Integer.MAX_VALUE) {
                    return;
                }
                long l = RateLimitableRequestPublisher.this.limit;
                int d = RateLimitableRequestPublisher.this.deliveredElements + 1;
                if ((long)d == l) {
                    long r;
                    Subscription s;
                    d = 0;
                    RateLimitableRequestPublisher rateLimitableRequestPublisher = RateLimitableRequestPublisher.this;
                    synchronized (rateLimitableRequestPublisher) {
                        long er = RateLimitableRequestPublisher.this.externalRequested;
                        s = RateLimitableRequestPublisher.this.internalSubscription;
                        if (s == null) {
                            return;
                        }
                        if (er >= l) {
                            er -= l;
                            r = l;
                        } else {
                            RateLimitableRequestPublisher.this.pendingToFulfil = (int)((long)RateLimitableRequestPublisher.this.pendingToFulfil - l);
                            if (er > 0L) {
                                r = er;
                                er = 0L;
                                RateLimitableRequestPublisher.this.pendingToFulfil = (int)((long)RateLimitableRequestPublisher.this.pendingToFulfil + r);
                            } else {
                                r = 0L;
                            }
                        }
                        RateLimitableRequestPublisher.this.externalRequested = er;
                    }
                    if (r > 0L) {
                        s.request(r);
                    }
                }
                RateLimitableRequestPublisher.this.deliveredElements = d;
            }
            catch (Throwable e) {
                this.onError(e);
            }
        }

        public void onError(Throwable t) {
            this.destination.onError(t);
        }

        public void onComplete() {
            this.destination.onComplete();
        }

        public void request(long n) {
        }

        public void cancel() {
            RateLimitableRequestPublisher.this.cancel();
        }
    }
}

