/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public class UnicastMonoProcessor<O>
extends Mono<O>
implements Processor<O, O>,
CoreSubscriber<O>,
Disposable,
Subscription,
Scannable {
    volatile CoreSubscriber<? super O> actual;
    static final AtomicReferenceFieldUpdater<UnicastMonoProcessor, CoreSubscriber> ACTUAL = AtomicReferenceFieldUpdater.newUpdater(UnicastMonoProcessor.class, CoreSubscriber.class, "actual");
    volatile int once;
    static final AtomicIntegerFieldUpdater<UnicastMonoProcessor> ONCE = AtomicIntegerFieldUpdater.newUpdater(UnicastMonoProcessor.class, "once");
    Throwable error;
    volatile boolean terminated;
    O value;
    volatile Subscription subscription;
    static final AtomicReferenceFieldUpdater<UnicastMonoProcessor, Subscription> UPSTREAM = AtomicReferenceFieldUpdater.newUpdater(UnicastMonoProcessor.class, Subscription.class, "subscription");

    public static <T> UnicastMonoProcessor<T> create() {
        return new UnicastMonoProcessor();
    }

    public final void cancel() {
        if (this.isTerminated()) {
            return;
        }
        Subscription s = UPSTREAM.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            return;
        }
        if (s != null) {
            s.cancel();
        }
    }

    public void dispose() {
        Subscription s = UPSTREAM.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            return;
        }
        CancellationException e = new CancellationException("Disposed");
        this.error = e;
        this.value = null;
        this.terminated = true;
        if (s != null) {
            s.cancel();
        }
        CoreSubscriber<? super O> a = this.actual;
        ACTUAL.lazySet(this, null);
        if (a != null) {
            a.onError((Throwable)e);
        }
    }

    @Nullable
    public final Throwable getError() {
        return this.isTerminated() ? this.error : null;
    }

    public boolean isCancelled() {
        return this.isDisposed() && !this.isTerminated();
    }

    public final boolean isError() {
        return this.getError() != null;
    }

    public final boolean isTerminated() {
        return this.terminated;
    }

    public boolean isDisposed() {
        return this.subscription == Operators.cancelledSubscription();
    }

    public final void onComplete() {
        this.onNext(null);
    }

    public final void onError(Throwable cause) {
        Objects.requireNonNull(cause, "onError cannot be null");
        if (UPSTREAM.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            Operators.onErrorDropped((Throwable)cause, (Context)this.currentContext());
            return;
        }
        this.error = cause;
        this.value = null;
        this.terminated = true;
        CoreSubscriber<? super O> a = this.actual;
        ACTUAL.lazySet(this, null);
        if (a != null) {
            a.onError(cause);
        }
    }

    public final void onNext(@Nullable O value) {
        Subscription s = UPSTREAM.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            if (value != null) {
                Operators.onNextDropped(value, (Context)this.currentContext());
            }
            return;
        }
        this.value = value;
        this.terminated = true;
        CoreSubscriber<? super O> a = this.actual;
        ACTUAL.lazySet(this, null);
        if (value == null) {
            if (a != null) {
                a.onComplete();
            }
        } else {
            if (s != null) {
                s.cancel();
            }
            if (a != null) {
                a.onNext(value);
                a.onComplete();
            }
        }
    }

    public final void onSubscribe(Subscription subscription) {
        if (Operators.setOnce(UPSTREAM, (Object)((Object)this), (Subscription)subscription)) {
            subscription.request(Long.MAX_VALUE);
        }
    }

    @Nullable
    public O peek() {
        if (!this.isTerminated()) {
            return null;
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.error != null) {
            RuntimeException re = Exceptions.propagate((Throwable)this.error);
            re = Exceptions.addSuppressed((RuntimeException)re, (Throwable)new Exception("Mono#peek terminated with an error"));
            throw re;
        }
        return null;
    }

    public final void request(long n) {
        Operators.validate((long)n);
    }

    public Context currentContext() {
        CoreSubscriber<? super O> a = this.actual;
        return a != null ? a.currentContext() : Context.empty();
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        boolean c = this.isCancelled();
        if (key == Scannable.Attr.TERMINATED) {
            return this.isTerminated();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.subscription;
        }
        if (key == Scannable.Attr.ERROR) {
            return this.error;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return Integer.MAX_VALUE;
        }
        if (key == Scannable.Attr.CANCELLED) {
            return c;
        }
        return null;
    }

    public final boolean hasDownstream() {
        return this.actual != null;
    }

    public void subscribe(CoreSubscriber<? super O> actual) {
        Objects.requireNonNull(actual, "subscribe");
        if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
            actual.onSubscribe((Subscription)this);
            ACTUAL.lazySet(this, actual);
            if (this.isTerminated()) {
                Throwable ex = this.error;
                if (ex != null) {
                    actual.onError(ex);
                } else {
                    O v = this.value;
                    if (v != null) {
                        actual.onNext(v);
                    }
                    actual.onComplete();
                }
                ACTUAL.lazySet(this, null);
            }
        } else {
            Operators.error(actual, (Throwable)new IllegalStateException("UnicastMonoProcessor allows only a single Subscriber"));
        }
    }
}

