/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectMap;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.ResponderRSocket;
import io.rsocket.exceptions.ApplicationErrorException;
import io.rsocket.frame.CancelFrameFlyweight;
import io.rsocket.frame.ErrorFrameFlyweight;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameFlyweight;
import io.rsocket.frame.RequestChannelFrameFlyweight;
import io.rsocket.frame.RequestNFrameFlyweight;
import io.rsocket.frame.RequestStreamFrameFlyweight;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.RateLimitableRequestPublisher;
import io.rsocket.internal.SynchronizedIntObjectHashMap;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.lease.ResponderLeaseHandler;
import java.util.function.Consumer;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.UnicastProcessor;
import reactor.util.concurrent.Queues;

class RSocketResponder
implements ResponderRSocket {
    private final DuplexConnection connection;
    private final RSocket requestHandler;
    private final ResponderRSocket responderRSocket;
    private final PayloadDecoder payloadDecoder;
    private final Consumer<Throwable> errorConsumer;
    private final ResponderLeaseHandler leaseHandler;
    private final IntObjectMap<RateLimitableRequestPublisher> sendingLimitableSubscriptions;
    private final IntObjectMap<Subscription> sendingSubscriptions;
    private final IntObjectMap<Processor<Payload, Payload>> channelProcessors;
    private final UnboundedProcessor<ByteBuf> sendProcessor;
    private final ByteBufAllocator allocator;

    RSocketResponder(ByteBufAllocator allocator, DuplexConnection connection, RSocket requestHandler, PayloadDecoder payloadDecoder, Consumer<Throwable> errorConsumer, ResponderLeaseHandler leaseHandler) {
        this.allocator = allocator;
        this.connection = connection;
        this.requestHandler = requestHandler;
        this.responderRSocket = requestHandler instanceof ResponderRSocket ? (ResponderRSocket)requestHandler : null;
        this.payloadDecoder = payloadDecoder;
        this.errorConsumer = errorConsumer;
        this.leaseHandler = leaseHandler;
        this.sendingLimitableSubscriptions = new SynchronizedIntObjectHashMap<RateLimitableRequestPublisher>();
        this.sendingSubscriptions = new SynchronizedIntObjectHashMap<Subscription>();
        this.channelProcessors = new SynchronizedIntObjectHashMap<Processor<Payload, Payload>>();
        this.sendProcessor = new UnboundedProcessor();
        connection.send((Publisher<ByteBuf>)this.sendProcessor).doFinally(this::handleSendProcessorCancel).subscribe(null, this::handleSendProcessorError);
        Disposable receiveDisposable = connection.receive().subscribe(this::handleFrame, errorConsumer);
        Disposable sendLeaseDisposable = leaseHandler.send(this.sendProcessor::onNext);
        this.connection.onClose().doFinally(s -> {
            this.cleanup();
            receiveDisposable.dispose();
            sendLeaseDisposable.dispose();
        }).subscribe(null, errorConsumer);
    }

    private void handleSendProcessorError(Throwable t) {
        this.sendingSubscriptions.values().forEach(subscription -> {
            try {
                subscription.cancel();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
        this.sendingLimitableSubscriptions.values().forEach(subscription -> {
            try {
                subscription.cancel();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
        this.channelProcessors.values().forEach(subscription -> {
            try {
                subscription.onError(t);
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
    }

    private void handleSendProcessorCancel(SignalType t) {
        if (SignalType.ON_ERROR == t) {
            return;
        }
        this.sendingSubscriptions.values().forEach(subscription -> {
            try {
                subscription.cancel();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
        this.sendingLimitableSubscriptions.values().forEach(subscription -> {
            try {
                subscription.cancel();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
        this.channelProcessors.values().forEach(subscription -> {
            try {
                subscription.onComplete();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
    }

    @Override
    public Mono<Void> fireAndForget(Payload payload) {
        try {
            if (this.leaseHandler.useLease()) {
                return this.requestHandler.fireAndForget(payload);
            }
            payload.release();
            return Mono.error((Throwable)this.leaseHandler.leaseError());
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    @Override
    public Mono<Payload> requestResponse(Payload payload) {
        try {
            if (this.leaseHandler.useLease()) {
                return this.requestHandler.requestResponse(payload);
            }
            payload.release();
            return Mono.error((Throwable)this.leaseHandler.leaseError());
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    @Override
    public Flux<Payload> requestStream(Payload payload) {
        try {
            if (this.leaseHandler.useLease()) {
                return this.requestHandler.requestStream(payload);
            }
            payload.release();
            return Flux.error((Throwable)this.leaseHandler.leaseError());
        }
        catch (Throwable t) {
            return Flux.error((Throwable)t);
        }
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        try {
            if (this.leaseHandler.useLease()) {
                return this.requestHandler.requestChannel(payloads);
            }
            return Flux.error((Throwable)this.leaseHandler.leaseError());
        }
        catch (Throwable t) {
            return Flux.error((Throwable)t);
        }
    }

    @Override
    public Flux<Payload> requestChannel(Payload payload, Publisher<Payload> payloads) {
        try {
            if (this.leaseHandler.useLease()) {
                return this.responderRSocket.requestChannel(payload, payloads);
            }
            payload.release();
            return Flux.error((Throwable)this.leaseHandler.leaseError());
        }
        catch (Throwable t) {
            return Flux.error((Throwable)t);
        }
    }

    @Override
    public Mono<Void> metadataPush(Payload payload) {
        try {
            return this.requestHandler.metadataPush(payload);
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    public void dispose() {
        this.connection.dispose();
    }

    public boolean isDisposed() {
        return this.connection.isDisposed();
    }

    @Override
    public Mono<Void> onClose() {
        return this.connection.onClose();
    }

    private void cleanup() {
        this.cleanUpSendingSubscriptions();
        this.cleanUpChannelProcessors();
        this.requestHandler.dispose();
        this.sendProcessor.dispose();
    }

    private synchronized void cleanUpSendingSubscriptions() {
        this.sendingSubscriptions.values().forEach(Subscription::cancel);
        this.sendingSubscriptions.clear();
        this.sendingLimitableSubscriptions.values().forEach(Subscription::cancel);
        this.sendingLimitableSubscriptions.clear();
    }

    private synchronized void cleanUpChannelProcessors() {
        this.channelProcessors.values().forEach(Subscriber::onComplete);
        this.channelProcessors.clear();
    }

    private void handleFrame(ByteBuf frame) {
        try {
            int streamId = FrameHeaderFlyweight.streamId(frame);
            FrameType frameType = FrameHeaderFlyweight.frameType(frame);
            switch (frameType) {
                case REQUEST_FNF: {
                    this.handleFireAndForget(streamId, this.fireAndForget((Payload)this.payloadDecoder.apply(frame)));
                    break;
                }
                case REQUEST_RESPONSE: {
                    this.handleRequestResponse(streamId, this.requestResponse((Payload)this.payloadDecoder.apply(frame)));
                    break;
                }
                case CANCEL: {
                    this.handleCancelFrame(streamId);
                    break;
                }
                case REQUEST_N: {
                    this.handleRequestN(streamId, frame);
                    break;
                }
                case REQUEST_STREAM: {
                    int streamInitialRequestN = RequestStreamFrameFlyweight.initialRequestN(frame);
                    Payload streamPayload = (Payload)this.payloadDecoder.apply(frame);
                    this.handleStream(streamId, this.requestStream(streamPayload), streamInitialRequestN);
                    break;
                }
                case REQUEST_CHANNEL: {
                    int channelInitialRequestN = RequestChannelFrameFlyweight.initialRequestN(frame);
                    Payload channelPayload = (Payload)this.payloadDecoder.apply(frame);
                    this.handleChannel(streamId, channelPayload, channelInitialRequestN);
                    break;
                }
                case METADATA_PUSH: {
                    this.handleMetadataPush(this.metadataPush((Payload)this.payloadDecoder.apply(frame)));
                    break;
                }
                case PAYLOAD: {
                    break;
                }
                case NEXT: {
                    Subscriber receiver = (Subscriber)this.channelProcessors.get(streamId);
                    if (receiver == null) break;
                    receiver.onNext(this.payloadDecoder.apply(frame));
                    break;
                }
                case COMPLETE: {
                    Subscriber receiver = (Subscriber)this.channelProcessors.get(streamId);
                    if (receiver == null) break;
                    receiver.onComplete();
                    break;
                }
                case ERROR: {
                    Subscriber receiver = (Subscriber)this.channelProcessors.get(streamId);
                    if (receiver == null) break;
                    receiver.onError((Throwable)new ApplicationErrorException(ErrorFrameFlyweight.dataUtf8(frame)));
                    break;
                }
                case NEXT_COMPLETE: {
                    Subscriber receiver = (Subscriber)this.channelProcessors.get(streamId);
                    if (receiver == null) break;
                    receiver.onNext(this.payloadDecoder.apply(frame));
                    receiver.onComplete();
                    break;
                }
                case SETUP: {
                    this.handleError(streamId, new IllegalStateException("Setup frame received post setup."));
                    break;
                }
                default: {
                    this.handleError(streamId, new IllegalStateException("ServerRSocket: Unexpected frame type: " + (Object)((Object)frameType)));
                }
            }
            ReferenceCountUtil.safeRelease((Object)frame);
        }
        catch (Throwable t) {
            ReferenceCountUtil.safeRelease((Object)frame);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    private void handleFireAndForget(final int streamId, Mono<Void> result) {
        result.subscribe((CoreSubscriber)new BaseSubscriber<Void>(){

            protected void hookOnSubscribe(Subscription subscription) {
                RSocketResponder.this.sendingSubscriptions.put(streamId, (Object)subscription);
                subscription.request(Long.MAX_VALUE);
            }

            protected void hookOnError(Throwable throwable) {
                RSocketResponder.this.errorConsumer.accept(throwable);
            }

            protected void hookFinally(SignalType type) {
                RSocketResponder.this.sendingSubscriptions.remove(streamId);
            }
        });
    }

    private void handleRequestResponse(final int streamId, Mono<Payload> response) {
        response.subscribe((CoreSubscriber)new BaseSubscriber<Payload>(){
            private boolean isEmpty = true;

            protected void hookOnSubscribe(Subscription subscription) {
                RSocketResponder.this.sendingSubscriptions.put(streamId, (Object)subscription);
                subscription.request(Long.MAX_VALUE);
            }

            protected void hookOnNext(Payload payload) {
                ByteBuf byteBuf;
                if (this.isEmpty) {
                    this.isEmpty = false;
                }
                try {
                    byteBuf = PayloadFrameFlyweight.encodeNextComplete(RSocketResponder.this.allocator, streamId, payload);
                }
                catch (Throwable t) {
                    payload.release();
                    throw Exceptions.propagate((Throwable)t);
                }
                payload.release();
                RSocketResponder.this.sendProcessor.onNext(byteBuf);
            }

            protected void hookOnError(Throwable throwable) {
                RSocketResponder.this.handleError(streamId, throwable);
            }

            protected void hookOnComplete() {
                if (this.isEmpty) {
                    RSocketResponder.this.sendProcessor.onNext(PayloadFrameFlyweight.encodeComplete(RSocketResponder.this.allocator, streamId));
                }
            }

            protected void hookFinally(SignalType type) {
                RSocketResponder.this.sendingSubscriptions.remove(streamId);
            }
        });
    }

    private void handleStream(final int streamId, Flux<Payload> response, int initialRequestN) {
        response.transform(frameFlux -> {
            RateLimitableRequestPublisher payloads = RateLimitableRequestPublisher.wrap(frameFlux, Queues.SMALL_BUFFER_SIZE);
            this.sendingLimitableSubscriptions.put(streamId, payloads);
            payloads.request(initialRequestN >= Integer.MAX_VALUE ? Long.MAX_VALUE : (long)initialRequestN);
            return payloads;
        }).subscribe((CoreSubscriber)new BaseSubscriber<Payload>(){

            protected void hookOnNext(Payload payload) {
                ByteBuf byteBuf;
                try {
                    byteBuf = PayloadFrameFlyweight.encodeNext(RSocketResponder.this.allocator, streamId, payload);
                }
                catch (Throwable t) {
                    payload.release();
                    throw Exceptions.propagate((Throwable)t);
                }
                payload.release();
                RSocketResponder.this.sendProcessor.onNext(byteBuf);
            }

            protected void hookOnComplete() {
                RSocketResponder.this.sendProcessor.onNext(PayloadFrameFlyweight.encodeComplete(RSocketResponder.this.allocator, streamId));
            }

            protected void hookOnError(Throwable throwable) {
                RSocketResponder.this.handleError(streamId, throwable);
            }

            protected void hookFinally(SignalType type) {
                RSocketResponder.this.sendingLimitableSubscriptions.remove(streamId);
            }
        });
    }

    private void handleChannel(int streamId, Payload payload, int initialRequestN) {
        UnicastProcessor frames = UnicastProcessor.create();
        this.channelProcessors.put(streamId, (Object)frames);
        Flux payloads = frames.doOnCancel(() -> this.sendProcessor.onNext(CancelFrameFlyweight.encode(this.allocator, streamId))).doOnError(t -> this.handleError(streamId, (Throwable)t)).doOnRequest(l -> this.sendProcessor.onNext(RequestNFrameFlyweight.encode(this.allocator, streamId, l))).doFinally(signalType -> {
            Processor cfr_ignored_0 = (Processor)this.channelProcessors.remove(streamId);
        });
        frames.onNext((Object)payload);
        if (this.responderRSocket != null) {
            this.handleStream(streamId, this.requestChannel(payload, (Publisher<Payload>)payloads), initialRequestN);
        } else {
            this.handleStream(streamId, this.requestChannel((Publisher<Payload>)payloads), initialRequestN);
        }
    }

    private void handleMetadataPush(Mono<Void> result) {
        result.subscribe((CoreSubscriber)new BaseSubscriber<Void>(){

            protected void hookOnSubscribe(Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            protected void hookOnError(Throwable throwable) {
                RSocketResponder.this.errorConsumer.accept(throwable);
            }
        });
    }

    private void handleCancelFrame(int streamId) {
        Subscription subscription = (Subscription)this.sendingSubscriptions.remove(streamId);
        if (subscription == null) {
            subscription = (Subscription)this.sendingLimitableSubscriptions.remove(streamId);
        }
        if (subscription != null) {
            subscription.cancel();
        }
    }

    private void handleError(int streamId, Throwable t) {
        this.errorConsumer.accept(t);
        this.sendProcessor.onNext(ErrorFrameFlyweight.encode(this.allocator, streamId, t));
    }

    private void handleRequestN(int streamId, ByteBuf frame) {
        Subscription subscription = (Subscription)this.sendingSubscriptions.get(streamId);
        if (subscription == null) {
            subscription = (Subscription)this.sendingLimitableSubscriptions.get(streamId);
        }
        if (subscription != null) {
            int n = RequestNFrameFlyweight.requestN(frame);
            subscription.request(n >= Integer.MAX_VALUE ? Long.MAX_VALUE : (long)n);
        }
    }
}

