/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.buffer.AbstractTupleByteBuf;
import io.rsocket.buffer.BufferUtil;
import io.rsocket.buffer.Tuple2ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.Charset;

class Tuple3ByteBuf
extends AbstractTupleByteBuf {
    private static final long ONE_MASK = 0x100000000L;
    private static final long TWO_MASK = 0x200000000L;
    private static final long THREE_MASK = 0x400000000L;
    private static final long MASK = 0x700000000L;
    private final ByteBuf one;
    private final ByteBuf two;
    private final ByteBuf three;
    private final int oneReadIndex;
    private final int twoReadIndex;
    private final int threeReadIndex;
    private final int oneReadableBytes;
    private final int twoReadableBytes;
    private final int threeReadableBytes;
    private final int twoRelativeIndex;
    private final int threeRelativeIndex;
    private boolean freed;

    Tuple3ByteBuf(ByteBufAllocator allocator, ByteBuf one, ByteBuf two, ByteBuf three) {
        super(allocator, one.readableBytes() + two.readableBytes() + three.readableBytes());
        this.one = one;
        this.two = two;
        this.three = three;
        this.oneReadIndex = one.readerIndex();
        this.twoReadIndex = two.readerIndex();
        this.threeReadIndex = three.readerIndex();
        this.oneReadableBytes = one.readableBytes();
        this.twoReadableBytes = two.readableBytes();
        this.threeReadableBytes = three.readableBytes();
        this.twoRelativeIndex = this.oneReadableBytes;
        this.threeRelativeIndex = this.twoRelativeIndex + this.twoReadableBytes;
        this.freed = false;
    }

    public boolean isDirect() {
        return this.one.isDirect() && this.two.isDirect() && this.three.isDirect();
    }

    @Override
    public long calculateRelativeIndex(int index) {
        long mask;
        long relativeIndex;
        this.checkIndex(index, 0);
        if (index >= this.threeRelativeIndex) {
            relativeIndex = this.threeReadIndex + (index - this.twoReadableBytes - this.oneReadableBytes);
            mask = 0x400000000L;
        } else if (index >= this.twoRelativeIndex) {
            relativeIndex = this.twoReadIndex + (index - this.oneReadableBytes);
            mask = 0x200000000L;
        } else {
            relativeIndex = this.oneReadIndex + index;
            mask = 0x100000000L;
        }
        return relativeIndex | mask;
    }

    @Override
    public ByteBuf getPart(int index) {
        long ri = this.calculateRelativeIndex(index);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                return this.one;
            }
            case 2: {
                return this.two;
            }
            case 4: {
                return this.three;
            }
        }
        throw new IllegalStateException();
    }

    public int nioBufferCount() {
        return this.one.nioBufferCount() + this.two.nioBufferCount() + this.three.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        ByteBuffer[] oneBuffers = this.one.nioBuffers();
        ByteBuffer[] twoBuffers = this.two.nioBuffers();
        ByteBuffer[] threeBuffers = this.three.nioBuffers();
        ByteBuffer merged = BufferUtil.allocateDirectAligned(this.capacity, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT).order(this.order());
        for (ByteBuffer b : oneBuffers) {
            merged.put(b);
        }
        for (ByteBuffer b : twoBuffers) {
            merged.put(b);
        }
        for (ByteBuffer b : threeBuffers) {
            merged.put(b);
        }
        merged.flip();
        return merged;
    }

    @Override
    public ByteBuffer[] _nioBuffers(int index, int length) {
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                ByteBuffer[] oneBuffer = this.one.nioBuffers(index, l);
                if ((length -= l) != 0) {
                    l = Math.min(this.twoReadableBytes, length);
                    ByteBuffer[] twoBuffer = this.two.nioBuffers(this.twoReadIndex, l);
                    if ((length -= l) != 0) {
                        ByteBuffer[] threeBuffer = this.three.nioBuffers(this.threeReadIndex, length);
                        ByteBuffer[] results = new ByteBuffer[oneBuffer.length + twoBuffer.length + threeBuffer.length];
                        System.arraycopy(oneBuffer, 0, results, 0, oneBuffer.length);
                        System.arraycopy(twoBuffer, 0, results, oneBuffer.length, twoBuffer.length);
                        System.arraycopy(threeBuffer, 0, results, twoBuffer.length, threeBuffer.length);
                        return results;
                    }
                    ByteBuffer[] results = new ByteBuffer[oneBuffer.length + twoBuffer.length];
                    System.arraycopy(oneBuffer, 0, results, 0, oneBuffer.length);
                    System.arraycopy(twoBuffer, 0, results, oneBuffer.length, twoBuffer.length);
                    return results;
                }
                return oneBuffer;
            }
            case 2: {
                int l = Math.min(this.twoReadableBytes - index, length);
                ByteBuffer[] twoBuffer = this.two.nioBuffers(index, length);
                if ((length -= l) != 0) {
                    ByteBuffer[] threeBuffer = this.three.nioBuffers(this.threeReadIndex, length);
                    ByteBuffer[] results = new ByteBuffer[twoBuffer.length + threeBuffer.length];
                    System.arraycopy(twoBuffer, 0, results, 0, twoBuffer.length);
                    System.arraycopy(threeBuffer, 0, results, threeBuffer.length, twoBuffer.length);
                    return results;
                }
                return twoBuffer;
            }
            case 4: {
                return this.three.nioBuffers(index, length);
            }
        }
        throw new IllegalStateException();
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                this.one.getBytes(index, dst, dstIndex, l);
                dstIndex += l;
                if ((length -= l) == 0) break;
                l = Math.min(this.twoReadableBytes, length);
                this.two.getBytes(this.twoReadIndex, dst, dstIndex, l);
                dstIndex += l;
                if ((length -= l) == 0) break;
                this.three.getBytes(this.threeReadIndex, dst, dstIndex, length);
                break;
            }
            case 2: {
                int l = Math.min(this.twoReadableBytes - index, length);
                this.two.getBytes(index, dst, dstIndex, l);
                dstIndex += l;
                if ((length -= l) == 0) break;
                this.three.getBytes(this.threeReadIndex, dst, dstIndex, length);
                break;
            }
            case 4: {
                this.three.getBytes(index, dst, dstIndex, length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        ByteBuf dstBuf = Unpooled.wrappedBuffer((byte[])dst);
        int min = Math.min(dst.length, this.capacity);
        return this.getBytes(0, dstBuf, index, min);
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        ByteBuf dstBuf = Unpooled.wrappedBuffer((ByteBuffer)dst);
        int min = Math.min(dst.limit(), this.capacity);
        return this.getBytes(0, dstBuf, index, min);
    }

    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                this.one.getBytes(index, out, l);
                if ((length -= l) == 0) break;
                l = Math.min(this.twoReadableBytes, length);
                this.two.getBytes(this.twoReadIndex, out, l);
                if ((length -= l) == 0) break;
                this.three.getBytes(this.threeReadIndex, out, length);
                break;
            }
            case 2: {
                int l = Math.min(this.twoReadableBytes - index, length);
                this.two.getBytes(index, out, l);
                if ((length -= l) == 0) break;
                this.three.getBytes(this.threeReadIndex, out, length);
                break;
            }
            case 4: {
                this.three.getBytes(index, out, length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex(index, length);
        int read = 0;
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                read += this.one.getBytes(index, out, l);
                if ((length -= l) == 0) break;
                l = Math.min(this.twoReadableBytes, length);
                read += this.two.getBytes(this.twoReadIndex, out, l);
                if ((length -= l) == 0) break;
                read += this.three.getBytes(this.threeReadIndex, out, length);
                break;
            }
            case 2: {
                int l = Math.min(this.twoReadableBytes - index, length);
                read += this.two.getBytes(index, out, l);
                if ((length -= l) == 0) break;
                read += this.three.getBytes(this.threeReadIndex, out, length);
                break;
            }
            case 4: {
                read += this.three.getBytes(index, out, length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return read;
    }

    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        this.checkIndex(index, length);
        int read = 0;
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                read += this.one.getBytes(index, out, position, l);
                position += (long)l;
                if ((length -= l) == 0) break;
                l = Math.min(this.twoReadableBytes, length);
                read += this.two.getBytes(this.twoReadIndex, out, position, l);
                position += (long)l;
                if ((length -= l) == 0) break;
                read += this.three.getBytes(this.threeReadIndex, out, position, length);
                break;
            }
            case 2: {
                int l = Math.min(this.twoReadableBytes - index, length);
                read += this.two.getBytes(index, out, position, l);
                position += (long)l;
                if ((length -= l) == 0) break;
                read += this.three.getBytes(this.threeReadIndex, out, position, length);
                break;
            }
            case 4: {
                read += this.three.getBytes(index, out, position, length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return read;
    }

    public ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        ByteBuf buffer = this.allocator.buffer(length);
        if (index == 0 && length == this.capacity) {
            buffer.writeBytes(this.one, this.oneReadIndex, this.oneReadableBytes);
            buffer.writeBytes(this.two, this.twoReadIndex, this.twoReadableBytes);
            buffer.writeBytes(this.three, this.threeReadIndex, this.threeReadableBytes);
            return buffer;
        }
        long ri = this.calculateRelativeIndex(index);
        index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                buffer.writeBytes(this.one, index, l);
                if ((length -= l) != 0) {
                    l = Math.min(this.twoReadableBytes, length);
                    buffer.writeBytes(this.two, this.twoReadIndex, l);
                    if ((length -= l) != 0) {
                        buffer.writeBytes(this.three, this.threeReadIndex, length);
                    }
                }
                return buffer;
            }
            case 2: {
                int l = Math.min(this.twoReadableBytes - index, length);
                buffer.writeBytes(this.two, index, l);
                if ((length -= l) != 0) {
                    buffer.writeBytes(this.three, this.threeReadIndex, length);
                }
                return buffer;
            }
            case 4: {
                buffer.writeBytes(this.three, index, length);
                return buffer;
            }
        }
        throw new IllegalStateException();
    }

    public ByteBuf retainedSlice() {
        return new Tuple3ByteBuf(this.allocator, this.one.retainedSlice(this.oneReadIndex, this.oneReadableBytes), this.two.retainedSlice(this.twoReadIndex, this.twoReadableBytes), this.three.retainedSlice(this.threeReadIndex, this.threeReadableBytes));
    }

    public ByteBuf slice(int readIndex, int length) {
        this.checkIndex(readIndex, length);
        if (readIndex == 0 && length == this.capacity) {
            return new Tuple3ByteBuf(this.allocator, this.one.slice(this.oneReadIndex, this.oneReadableBytes), this.two.slice(this.twoReadIndex, this.twoReadableBytes), this.three.slice(this.threeReadIndex, this.threeReadableBytes));
        }
        long ri = this.calculateRelativeIndex(readIndex);
        int index = (int)(ri & Integer.MAX_VALUE);
        switch ((int)((ri & 0x700000000L) >>> 32)) {
            case 1: {
                int l = Math.min(this.oneReadableBytes - index, length);
                ByteBuf oneSlice = this.one.slice(index, l);
                if ((length -= l) != 0) {
                    l = Math.min(this.twoReadableBytes, length);
                    ByteBuf twoSlice = this.two.slice(this.twoReadIndex, l);
                    if ((length -= l) != 0) {
                        ByteBuf threeSlice = this.three.slice(this.threeReadIndex, length);
                        return new Tuple3ByteBuf(this.allocator, oneSlice, twoSlice, threeSlice);
                    }
                    return new Tuple2ByteBuf(this.allocator, oneSlice, twoSlice);
                }
                return oneSlice;
            }
            case 2: {
                int l = Math.min(this.twoReadableBytes - index, length);
                ByteBuf twoSlice = this.two.slice(index, l);
                if ((length -= l) != 0) {
                    ByteBuf threeSlice = this.three.slice(this.threeReadIndex, length);
                    return new Tuple2ByteBuf(this.allocator, twoSlice, threeSlice);
                }
                return twoSlice;
            }
            case 4: {
                return this.three.slice(index, length);
            }
        }
        throw new IllegalStateException();
    }

    protected void deallocate() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        ReferenceCountUtil.safeRelease((Object)this.one);
        ReferenceCountUtil.safeRelease((Object)this.two);
        ReferenceCountUtil.safeRelease((Object)this.three);
    }

    public String toString(Charset charset) {
        StringBuilder builder = new StringBuilder(3);
        builder.append(this.one.toString(charset));
        builder.append(this.two.toString(charset));
        builder.append(this.three.toString(charset));
        return builder.toString();
    }

    public String toString(int index, int length, Charset charset) {
        return this.toString(charset).substring(index, length);
    }

    public String toString() {
        return "Tuple3ByteBuf{capacity=" + this.capacity + ", one=" + this.one + ", two=" + this.two + ", three=" + this.three + ", allocator=" + this.allocator + ", oneReadIndex=" + this.oneReadIndex + ", twoReadIndex=" + this.twoReadIndex + ", threeReadIndex=" + this.threeReadIndex + ", oneReadableBytes=" + this.oneReadableBytes + ", twoReadableBytes=" + this.twoReadableBytes + ", threeReadableBytes=" + this.threeReadableBytes + ", twoRelativeIndex=" + this.twoRelativeIndex + ", threeRelativeIndex=" + this.threeRelativeIndex + '}';
    }
}

