/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.lease;

import io.netty.buffer.ByteBuf;
import io.rsocket.frame.LeaseFlyweight;
import io.rsocket.lease.Lease;
import reactor.util.annotation.Nullable;

public final class LeaseImpl
implements Lease {
    private final int allowedRequests;
    private final int ttl;
    private final long expiry;
    @Nullable
    private final ByteBuf metadata;

    public LeaseImpl(int allowedRequests, int ttl) {
        this(allowedRequests, ttl, null);
    }

    public LeaseImpl(int allowedRequests, int ttl, ByteBuf metadata) {
        this.allowedRequests = allowedRequests;
        this.ttl = ttl;
        this.expiry = System.currentTimeMillis() + (long)ttl;
        this.metadata = metadata;
    }

    public LeaseImpl(ByteBuf leaseFrame) {
        this(LeaseFlyweight.numRequests(leaseFrame), LeaseFlyweight.ttl(leaseFrame), LeaseFlyweight.metadata(leaseFrame));
    }

    @Override
    public int getAllowedRequests() {
        return this.allowedRequests;
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    @Override
    public long expiry() {
        return this.expiry;
    }

    @Override
    public ByteBuf getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "LeaseImpl{allowedRequests=" + this.allowedRequests + ", ttl=" + this.ttl + ", expiry=" + this.expiry + '}';
    }
}

