/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.rsocket.DuplexConnection;
import io.rsocket.KeepAliveHandler;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.exceptions.ApplicationErrorException;
import io.rsocket.exceptions.ConnectionErrorException;
import io.rsocket.frame.CancelFrameFlyweight;
import io.rsocket.frame.ErrorFrameFlyweight;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameFlyweight;
import io.rsocket.frame.RequestChannelFrameFlyweight;
import io.rsocket.frame.RequestNFrameFlyweight;
import io.rsocket.frame.RequestStreamFrameFlyweight;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.LimitableRequestPublisher;
import io.rsocket.internal.UnboundedProcessor;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.UnicastProcessor;

class RSocketServer
implements RSocket {
    private final DuplexConnection connection;
    private final RSocket requestHandler;
    private final PayloadDecoder payloadDecoder;
    private final Consumer<Throwable> errorConsumer;
    private final Map<Integer, Subscription> sendingSubscriptions;
    private final Map<Integer, Processor<Payload, Payload>> channelProcessors;
    private final UnboundedProcessor<ByteBuf> sendProcessor;
    private final ByteBufAllocator allocator;
    private KeepAliveHandler keepAliveHandler;

    RSocketServer(ByteBufAllocator allocator, DuplexConnection connection, RSocket requestHandler, PayloadDecoder payloadDecoder, Consumer<Throwable> errorConsumer) {
        this(allocator, connection, requestHandler, payloadDecoder, errorConsumer, 0L, 0L);
    }

    RSocketServer(ByteBufAllocator allocator, DuplexConnection connection, RSocket requestHandler, PayloadDecoder payloadDecoder, Consumer<Throwable> errorConsumer, long tickPeriod, long ackTimeout) {
        this.allocator = allocator;
        this.connection = connection;
        this.requestHandler = requestHandler;
        this.payloadDecoder = payloadDecoder;
        this.errorConsumer = errorConsumer;
        this.sendingSubscriptions = Collections.synchronizedMap(new IntObjectHashMap());
        this.channelProcessors = Collections.synchronizedMap(new IntObjectHashMap());
        this.sendProcessor = new UnboundedProcessor();
        connection.send((Publisher<ByteBuf>)this.sendProcessor).doFinally(this::handleSendProcessorCancel).subscribe(null, this::handleSendProcessorError);
        Disposable receiveDisposable = connection.receive().subscribe(this::handleFrame, errorConsumer);
        this.connection.onClose().doFinally(s -> {
            this.cleanup();
            receiveDisposable.dispose();
        }).subscribe(null, errorConsumer);
        if (tickPeriod != 0L) {
            this.keepAliveHandler = KeepAliveHandler.ofServer(new KeepAliveHandler.KeepAlive(tickPeriod, ackTimeout));
            this.keepAliveHandler.timeout().subscribe(keepAlive -> {
                String message = String.format("No keep-alive acks for %d ms", keepAlive.getTimeoutMillis());
                errorConsumer.accept(new ConnectionErrorException(message));
                connection.dispose();
            });
            this.keepAliveHandler.send().subscribe(this.sendProcessor::onNext);
        } else {
            this.keepAliveHandler = null;
        }
    }

    private void handleSendProcessorError(Throwable t) {
        this.sendingSubscriptions.values().forEach(subscription -> {
            try {
                subscription.cancel();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
        this.channelProcessors.values().forEach(subscription -> {
            try {
                subscription.onError(t);
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
    }

    private void handleSendProcessorCancel(SignalType t) {
        if (SignalType.ON_ERROR == t) {
            return;
        }
        this.sendingSubscriptions.values().forEach(subscription -> {
            try {
                subscription.cancel();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
        this.channelProcessors.values().forEach(subscription -> {
            try {
                subscription.onComplete();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        });
    }

    @Override
    public Mono<Void> fireAndForget(Payload payload) {
        try {
            return this.requestHandler.fireAndForget(payload);
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    @Override
    public Mono<Payload> requestResponse(Payload payload) {
        try {
            return this.requestHandler.requestResponse(payload);
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    @Override
    public Flux<Payload> requestStream(Payload payload) {
        try {
            return this.requestHandler.requestStream(payload);
        }
        catch (Throwable t) {
            return Flux.error((Throwable)t);
        }
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        try {
            return this.requestHandler.requestChannel(payloads);
        }
        catch (Throwable t) {
            return Flux.error((Throwable)t);
        }
    }

    @Override
    public Mono<Void> metadataPush(Payload payload) {
        try {
            return this.requestHandler.metadataPush(payload);
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    public void dispose() {
        this.connection.dispose();
    }

    public boolean isDisposed() {
        return this.connection.isDisposed();
    }

    @Override
    public Mono<Void> onClose() {
        return this.connection.onClose();
    }

    private void cleanup() {
        if (this.keepAliveHandler != null) {
            this.keepAliveHandler.dispose();
        }
        this.cleanUpSendingSubscriptions();
        this.cleanUpChannelProcessors();
        this.requestHandler.dispose();
        this.sendProcessor.dispose();
    }

    private synchronized void cleanUpSendingSubscriptions() {
        this.sendingSubscriptions.values().forEach(Subscription::cancel);
        this.sendingSubscriptions.clear();
    }

    private synchronized void cleanUpChannelProcessors() {
        this.channelProcessors.values().forEach(Subscriber::onComplete);
        this.channelProcessors.clear();
    }

    private void handleFrame(ByteBuf frame) {
        try {
            int streamId = FrameHeaderFlyweight.streamId(frame);
            FrameType frameType = FrameHeaderFlyweight.frameType(frame);
            switch (frameType) {
                case REQUEST_FNF: {
                    this.handleFireAndForget(streamId, this.fireAndForget((Payload)this.payloadDecoder.apply(frame)));
                    break;
                }
                case REQUEST_RESPONSE: {
                    this.handleRequestResponse(streamId, this.requestResponse((Payload)this.payloadDecoder.apply(frame)));
                    break;
                }
                case CANCEL: {
                    this.handleCancelFrame(streamId);
                    break;
                }
                case KEEPALIVE: {
                    this.handleKeepAliveFrame(frame);
                    break;
                }
                case REQUEST_N: {
                    this.handleRequestN(streamId, frame);
                    break;
                }
                case REQUEST_STREAM: {
                    this.handleStream(streamId, this.requestStream((Payload)this.payloadDecoder.apply(frame)), RequestStreamFrameFlyweight.initialRequestN(frame));
                    break;
                }
                case REQUEST_CHANNEL: {
                    this.handleChannel(streamId, (Payload)this.payloadDecoder.apply(frame), RequestChannelFrameFlyweight.initialRequestN(frame));
                    break;
                }
                case METADATA_PUSH: {
                    this.metadataPush((Payload)this.payloadDecoder.apply(frame));
                    break;
                }
                case PAYLOAD: {
                    break;
                }
                case LEASE: {
                    break;
                }
                case NEXT: {
                    Subscriber receiver = (Subscriber)this.channelProcessors.get(streamId);
                    if (receiver == null) break;
                    receiver.onNext(this.payloadDecoder.apply(frame));
                    break;
                }
                case COMPLETE: {
                    Subscriber receiver = (Subscriber)this.channelProcessors.get(streamId);
                    if (receiver == null) break;
                    receiver.onComplete();
                    break;
                }
                case ERROR: {
                    Subscriber receiver = (Subscriber)this.channelProcessors.get(streamId);
                    if (receiver == null) break;
                    receiver.onError((Throwable)new ApplicationErrorException(ErrorFrameFlyweight.dataUtf8(frame)));
                    break;
                }
                case NEXT_COMPLETE: {
                    Subscriber receiver = (Subscriber)this.channelProcessors.get(streamId);
                    if (receiver == null) break;
                    receiver.onNext(this.payloadDecoder.apply(frame));
                    receiver.onComplete();
                    break;
                }
                case SETUP: {
                    this.handleError(streamId, new IllegalStateException("Setup frame received post setup."));
                    break;
                }
                default: {
                    this.handleError(streamId, new IllegalStateException("ServerRSocket: Unexpected frame type: " + (Object)((Object)frameType)));
                }
            }
            ReferenceCountUtil.safeRelease((Object)frame);
        }
        catch (Throwable t) {
            ReferenceCountUtil.safeRelease((Object)frame);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    private void handleFireAndForget(int streamId, Mono<Void> result) {
        result.doOnSubscribe(subscription -> this.sendingSubscriptions.put(streamId, (Subscription)subscription)).doFinally(signalType -> this.sendingSubscriptions.remove(streamId)).subscribe(null, this.errorConsumer);
    }

    private void handleRequestResponse(int streamId, Mono<Payload> response) {
        response.doOnSubscribe(subscription -> this.sendingSubscriptions.put(streamId, (Subscription)subscription)).map(payload -> {
            ByteBuf byteBuf;
            block2: {
                byteBuf = null;
                try {
                    byteBuf = PayloadFrameFlyweight.encodeNextComplete(this.allocator, streamId, payload);
                }
                catch (Throwable t) {
                    if (byteBuf == null) break block2;
                    ReferenceCountUtil.safeRelease((Object)byteBuf);
                    ReferenceCountUtil.safeRelease((Object)payload);
                }
            }
            payload.release();
            return byteBuf;
        }).switchIfEmpty(Mono.fromCallable(() -> PayloadFrameFlyweight.encodeComplete(this.allocator, streamId))).doFinally(signalType -> this.sendingSubscriptions.remove(streamId)).subscribe(t1 -> this.sendProcessor.onNext((ByteBuf)t1), t -> this.handleError(streamId, (Throwable)t));
    }

    private void handleStream(int streamId, Flux<Payload> response, int initialRequestN) {
        response.transform(frameFlux -> {
            LimitableRequestPublisher payloads = LimitableRequestPublisher.wrap(frameFlux);
            this.sendingSubscriptions.put(streamId, payloads);
            payloads.increaseRequestLimit(initialRequestN);
            return payloads;
        }).doFinally(signalType -> this.sendingSubscriptions.remove(streamId)).subscribe(payload -> {
            ByteBuf byteBuf = null;
            try {
                byteBuf = PayloadFrameFlyweight.encodeNext(this.allocator, streamId, payload);
            }
            catch (Throwable t) {
                if (byteBuf != null) {
                    ReferenceCountUtil.safeRelease((Object)byteBuf);
                    ReferenceCountUtil.safeRelease((Object)payload);
                }
                throw Exceptions.propagate((Throwable)t);
            }
            payload.release();
            this.sendProcessor.onNext(byteBuf);
        }, t -> this.handleError(streamId, (Throwable)t), () -> this.sendProcessor.onNext(PayloadFrameFlyweight.encodeComplete(this.allocator, streamId)));
    }

    private void handleChannel(int streamId, Payload payload, int initialRequestN) {
        UnicastProcessor frames = UnicastProcessor.create();
        this.channelProcessors.put(streamId, (Processor<Payload, Payload>)frames);
        Flux payloads = frames.doOnCancel(() -> this.sendProcessor.onNext(CancelFrameFlyweight.encode(this.allocator, streamId))).doOnError(t -> this.handleError(streamId, (Throwable)t)).doOnRequest(l -> this.sendProcessor.onNext(RequestNFrameFlyweight.encode(this.allocator, streamId, l))).doFinally(signalType -> this.channelProcessors.remove(streamId));
        frames.onNext((Object)payload);
        this.handleStream(streamId, this.requestChannel((Publisher<Payload>)payloads), initialRequestN);
    }

    private void handleKeepAliveFrame(ByteBuf frame) {
        if (this.keepAliveHandler != null) {
            this.keepAliveHandler.receive(frame);
        }
    }

    private void handleCancelFrame(int streamId) {
        Subscription subscription = this.sendingSubscriptions.remove(streamId);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    private void handleError(int streamId, Throwable t) {
        this.errorConsumer.accept(t);
        this.sendProcessor.onNext(ErrorFrameFlyweight.encode(this.allocator, streamId, t));
    }

    private void handleRequestN(int streamId, ByteBuf frame) {
        Subscription subscription = this.sendingSubscriptions.get(streamId);
        if (subscription != null) {
            int n = RequestNFrameFlyweight.requestN(frame);
            subscription.request(n >= Integer.MAX_VALUE ? Long.MAX_VALUE : (long)n);
        }
    }
}

