/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.AbstractRSocket;
import io.rsocket.Closeable;
import io.rsocket.ConnectionSetupPayload;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.RSocketClient;
import io.rsocket.RSocketServer;
import io.rsocket.SocketAcceptor;
import io.rsocket.StreamIdSupplier;
import io.rsocket.exceptions.InvalidSetupException;
import io.rsocket.exceptions.RejectedSetupException;
import io.rsocket.frame.ErrorFrameFlyweight;
import io.rsocket.frame.SetupFrameFlyweight;
import io.rsocket.frame.VersionFlyweight;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.ClientServerInputMultiplexer;
import io.rsocket.plugins.DuplexConnectionInterceptor;
import io.rsocket.plugins.PluginRegistry;
import io.rsocket.plugins.Plugins;
import io.rsocket.plugins.RSocketInterceptor;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import io.rsocket.util.EmptyPayload;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class RSocketFactory {
    public static ClientRSocketFactory connect() {
        return new ClientRSocketFactory();
    }

    public static ServerRSocketFactory receive() {
        return new ServerRSocketFactory();
    }

    public static class ServerRSocketFactory {
        private SocketAcceptor acceptor;
        private PayloadDecoder payloadDecoder = PayloadDecoder.DEFAULT;
        private Consumer<Throwable> errorConsumer = Throwable::printStackTrace;
        private int mtu = 0;
        private PluginRegistry plugins = new PluginRegistry(Plugins.defaultPlugins());
        private ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;

        private ServerRSocketFactory() {
        }

        public ServerRSocketFactory byteBufAllocator(ByteBufAllocator allocator) {
            Objects.requireNonNull(allocator);
            this.allocator = allocator;
            return this;
        }

        public ServerRSocketFactory addConnectionPlugin(DuplexConnectionInterceptor interceptor) {
            this.plugins.addConnectionPlugin(interceptor);
            return this;
        }

        public ServerRSocketFactory addClientPlugin(RSocketInterceptor interceptor) {
            this.plugins.addClientPlugin(interceptor);
            return this;
        }

        public ServerRSocketFactory addServerPlugin(RSocketInterceptor interceptor) {
            this.plugins.addServerPlugin(interceptor);
            return this;
        }

        public ServerTransportAcceptor acceptor(SocketAcceptor acceptor) {
            this.acceptor = acceptor;
            return x$0 -> new ServerStart(x$0);
        }

        public ServerRSocketFactory frameDecoder(PayloadDecoder payloadDecoder) {
            this.payloadDecoder = payloadDecoder;
            return this;
        }

        public ServerRSocketFactory fragment(int mtu) {
            this.mtu = mtu;
            return this;
        }

        public ServerRSocketFactory errorConsumer(Consumer<Throwable> errorConsumer) {
            this.errorConsumer = errorConsumer;
            return this;
        }

        private class ServerStart<T extends Closeable>
        implements Start<T> {
            private final Supplier<ServerTransport<T>> transportServer;

            ServerStart(Supplier<ServerTransport<T>> transportServer) {
                this.transportServer = transportServer;
            }

            @Override
            public Mono<T> start() {
                return this.transportServer.get().start(connection -> {
                    ClientServerInputMultiplexer multiplexer = new ClientServerInputMultiplexer(connection, ServerRSocketFactory.this.plugins);
                    return multiplexer.asStreamZeroConnection().receive().next().flatMap(setupFrame -> this.processSetupFrame(multiplexer, (ByteBuf)setupFrame));
                }, ServerRSocketFactory.this.mtu);
            }

            private Mono<Void> processSetupFrame(ClientServerInputMultiplexer multiplexer, ByteBuf setupFrame) {
                int version = SetupFrameFlyweight.version(setupFrame);
                if (version != SetupFrameFlyweight.CURRENT_VERSION) {
                    setupFrame.release();
                    InvalidSetupException error = new InvalidSetupException("Unsupported version " + VersionFlyweight.toString(version));
                    return multiplexer.asStreamZeroConnection().sendOne(ErrorFrameFlyweight.encode(ByteBufAllocator.DEFAULT, 0, error)).doFinally(signalType -> multiplexer.dispose());
                }
                ConnectionSetupPayload setupPayload = ConnectionSetupPayload.create(setupFrame);
                int keepAliveInterval = setupPayload.keepAliveInterval();
                int keepAliveMaxLifetime = setupPayload.keepAliveMaxLifetime();
                RSocketClient rSocketClient = new RSocketClient(ServerRSocketFactory.this.allocator, multiplexer.asServerConnection(), ServerRSocketFactory.this.payloadDecoder, ServerRSocketFactory.this.errorConsumer, StreamIdSupplier.serverSupplier());
                RSocket wrappedRSocketClient = ServerRSocketFactory.this.plugins.applyClient(rSocketClient);
                return ServerRSocketFactory.this.acceptor.accept(setupPayload, wrappedRSocketClient).onErrorResume(err -> multiplexer.asStreamZeroConnection().sendOne(this.rejectedSetupErrorFrame((Throwable)err)).then(Mono.error((Throwable)err))).doOnNext(unwrappedServerSocket -> {
                    RSocket wrappedRSocketServer = ServerRSocketFactory.this.plugins.applyServer((RSocket)unwrappedServerSocket);
                    RSocketServer rSocketServer = new RSocketServer(ServerRSocketFactory.this.allocator, multiplexer.asClientConnection(), wrappedRSocketServer, ServerRSocketFactory.this.payloadDecoder, ServerRSocketFactory.this.errorConsumer, keepAliveInterval, keepAliveMaxLifetime);
                }).doFinally(signalType -> setupPayload.release()).then();
            }

            private ByteBuf rejectedSetupErrorFrame(Throwable err) {
                String msg = err.getMessage();
                return ErrorFrameFlyweight.encode(ByteBufAllocator.DEFAULT, 0, new RejectedSetupException(msg == null ? "rejected by server acceptor" : msg));
            }
        }
    }

    public static class ClientRSocketFactory
    implements ClientTransportAcceptor {
        private Supplier<Function<RSocket, RSocket>> acceptor = () -> rSocket -> new AbstractRSocket(){};
        private Consumer<Throwable> errorConsumer = Throwable::printStackTrace;
        private int mtu = 0;
        private PluginRegistry plugins = new PluginRegistry(Plugins.defaultPlugins());
        private Payload setupPayload = EmptyPayload.INSTANCE;
        private PayloadDecoder payloadDecoder = PayloadDecoder.DEFAULT;
        private Duration tickPeriod = Duration.ofSeconds(20L);
        private Duration ackTimeout = Duration.ofSeconds(30L);
        private int missedAcks = 3;
        private String metadataMimeType = "application/binary";
        private String dataMimeType = "application/binary";
        private ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;

        public ClientRSocketFactory byteBufAllocator(ByteBufAllocator allocator) {
            Objects.requireNonNull(allocator);
            this.allocator = allocator;
            return this;
        }

        public ClientRSocketFactory addConnectionPlugin(DuplexConnectionInterceptor interceptor) {
            this.plugins.addConnectionPlugin(interceptor);
            return this;
        }

        public ClientRSocketFactory addClientPlugin(RSocketInterceptor interceptor) {
            this.plugins.addClientPlugin(interceptor);
            return this;
        }

        public ClientRSocketFactory addServerPlugin(RSocketInterceptor interceptor) {
            this.plugins.addServerPlugin(interceptor);
            return this;
        }

        @Deprecated
        public ClientRSocketFactory keepAlive() {
            return this;
        }

        public ClientRSocketFactory keepAlive(Duration tickPeriod, Duration ackTimeout, int missedAcks) {
            this.tickPeriod = tickPeriod;
            this.ackTimeout = ackTimeout;
            this.missedAcks = missedAcks;
            return this;
        }

        public ClientRSocketFactory keepAliveTickPeriod(Duration tickPeriod) {
            this.tickPeriod = tickPeriod;
            return this;
        }

        public ClientRSocketFactory keepAliveAckTimeout(Duration ackTimeout) {
            this.ackTimeout = ackTimeout;
            return this;
        }

        public ClientRSocketFactory keepAliveMissedAcks(int missedAcks) {
            this.missedAcks = missedAcks;
            return this;
        }

        public ClientRSocketFactory mimeType(String metadataMimeType, String dataMimeType) {
            this.dataMimeType = dataMimeType;
            this.metadataMimeType = metadataMimeType;
            return this;
        }

        public ClientRSocketFactory dataMimeType(String dataMimeType) {
            this.dataMimeType = dataMimeType;
            return this;
        }

        public ClientRSocketFactory metadataMimeType(String metadataMimeType) {
            this.metadataMimeType = metadataMimeType;
            return this;
        }

        @Override
        public Start<RSocket> transport(Supplier<ClientTransport> transportClient) {
            return new StartClient(transportClient);
        }

        public ClientTransportAcceptor acceptor(Function<RSocket, RSocket> acceptor) {
            this.acceptor = () -> acceptor;
            return x$0 -> new StartClient(x$0);
        }

        public ClientTransportAcceptor acceptor(Supplier<Function<RSocket, RSocket>> acceptor) {
            this.acceptor = acceptor;
            return x$0 -> new StartClient(x$0);
        }

        public ClientRSocketFactory fragment(int mtu) {
            this.mtu = mtu;
            return this;
        }

        public ClientRSocketFactory errorConsumer(Consumer<Throwable> errorConsumer) {
            this.errorConsumer = errorConsumer;
            return this;
        }

        public ClientRSocketFactory setupPayload(Payload payload) {
            this.setupPayload = payload;
            return this;
        }

        public ClientRSocketFactory frameDecoder(PayloadDecoder payloadDecoder) {
            this.payloadDecoder = payloadDecoder;
            return this;
        }

        private class StartClient
        implements Start<RSocket> {
            private final Supplier<ClientTransport> transportClient;

            StartClient(Supplier<ClientTransport> transportClient) {
                this.transportClient = transportClient;
            }

            @Override
            public Mono<RSocket> start() {
                return this.transportClient.get().connect(ClientRSocketFactory.this.mtu).flatMap(connection -> {
                    ByteBuf setupFrame = SetupFrameFlyweight.encode(ClientRSocketFactory.this.allocator, false, false, (int)ClientRSocketFactory.this.tickPeriod.toMillis(), (int)(ClientRSocketFactory.this.ackTimeout.toMillis() + ClientRSocketFactory.this.tickPeriod.toMillis() * (long)ClientRSocketFactory.this.missedAcks), ClientRSocketFactory.this.metadataMimeType, ClientRSocketFactory.this.dataMimeType, ClientRSocketFactory.this.setupPayload.sliceMetadata(), ClientRSocketFactory.this.setupPayload.sliceData());
                    ClientServerInputMultiplexer multiplexer = new ClientServerInputMultiplexer((DuplexConnection)connection, ClientRSocketFactory.this.plugins);
                    RSocketClient rSocketClient = new RSocketClient(ClientRSocketFactory.this.allocator, multiplexer.asClientConnection(), ClientRSocketFactory.this.payloadDecoder, ClientRSocketFactory.this.errorConsumer, StreamIdSupplier.clientSupplier(), ClientRSocketFactory.this.tickPeriod, ClientRSocketFactory.this.ackTimeout, ClientRSocketFactory.this.missedAcks);
                    RSocket wrappedRSocketClient = ClientRSocketFactory.this.plugins.applyClient(rSocketClient);
                    RSocket unwrappedServerSocket = (RSocket)((Function)ClientRSocketFactory.this.acceptor.get()).apply(wrappedRSocketClient);
                    RSocket wrappedRSocketServer = ClientRSocketFactory.this.plugins.applyServer(unwrappedServerSocket);
                    RSocketServer rSocketServer = new RSocketServer(ClientRSocketFactory.this.allocator, multiplexer.asServerConnection(), wrappedRSocketServer, ClientRSocketFactory.this.payloadDecoder, ClientRSocketFactory.this.errorConsumer);
                    return connection.sendOne(setupFrame).thenReturn((Object)wrappedRSocketClient);
                });
            }
        }
    }

    public static interface ServerTransportAcceptor {
        public <T extends Closeable> Start<T> transport(Supplier<ServerTransport<T>> var1);

        default public <T extends Closeable> Start<T> transport(ServerTransport<T> transport) {
            return this.transport(() -> transport);
        }
    }

    public static interface ClientTransportAcceptor {
        public Start<RSocket> transport(Supplier<ClientTransport> var1);

        default public Start<RSocket> transport(ClientTransport transport) {
            return this.transport(() -> transport);
        }
    }

    public static interface Start<T extends Closeable> {
        public Mono<T> start();
    }
}

