/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.netty.util.ReferenceCountUtil;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public final class SwitchTransformFlux<T, R>
extends Flux<R> {
    final Publisher<? extends T> source;
    final BiFunction<T, Flux<T>, Publisher<? extends R>> transformer;

    public SwitchTransformFlux(Publisher<? extends T> source, BiFunction<T, Flux<T>, Publisher<? extends R>> transformer) {
        this.source = Objects.requireNonNull(source, "source");
        this.transformer = Objects.requireNonNull(transformer, "transformer");
    }

    public int getPrefetch() {
        return 1;
    }

    public void subscribe(CoreSubscriber<? super R> actual) {
        this.source.subscribe(new SwitchTransformMain<T, R>(actual, this.transformer));
    }

    static final class SwitchTransformInner<V>
    extends Flux<V>
    implements Scannable,
    Subscription {
        final SwitchTransformMain<V, ?> parent;
        volatile CoreSubscriber<? super V> actual;
        static final AtomicReferenceFieldUpdater<SwitchTransformInner, CoreSubscriber> ACTUAL = AtomicReferenceFieldUpdater.newUpdater(SwitchTransformInner.class, CoreSubscriber.class, "actual");
        volatile V first;
        static final AtomicReferenceFieldUpdater<SwitchTransformInner, Object> FIRST = AtomicReferenceFieldUpdater.newUpdater(SwitchTransformInner.class, Object.class, "first");
        volatile int once;
        static final AtomicIntegerFieldUpdater<SwitchTransformInner> ONCE = AtomicIntegerFieldUpdater.newUpdater(SwitchTransformInner.class, "once");

        SwitchTransformInner(SwitchTransformMain<V, ?> parent) {
            this.parent = parent;
        }

        public void onNext(V t) {
            CoreSubscriber<? super V> a = this.actual;
            if (a != null) {
                a.onNext(t);
            }
        }

        public void onError(Throwable t) {
            CoreSubscriber<? super V> a = this.actual;
            if (a != null) {
                a.onError(t);
            }
        }

        public void onComplete() {
            CoreSubscriber<? super V> a = this.actual;
            if (a != null) {
                a.onComplete();
            }
        }

        public void subscribe(CoreSubscriber<? super V> actual) {
            if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
                ACTUAL.lazySet(this, actual);
                actual.onSubscribe((Subscription)this);
            } else {
                actual.onError((Throwable)new IllegalStateException("SwitchTransform allows only one Subscriber"));
            }
        }

        public void request(long n) {
            V f = this.first;
            if (f != null && FIRST.compareAndSet(this, f, null)) {
                this.actual.onNext(f);
                long r = Operators.addCap((long)n, (long)-1L);
                if (r > 0L) {
                    this.parent.s.request(r);
                }
            } else {
                this.parent.s.request(n);
            }
        }

        public void cancel() {
            this.actual = null;
            this.first = null;
            this.parent.cancel();
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual();
            }
            return null;
        }

        public CoreSubscriber<? super V> actual() {
            return this.actual;
        }
    }

    static final class SwitchTransformMain<T, R>
    implements CoreSubscriber<T>,
    Scannable {
        final CoreSubscriber<? super R> actual;
        final BiFunction<T, Flux<T>, Publisher<? extends R>> transformer;
        final SwitchTransformInner<T> inner;
        Subscription s;
        volatile int once;
        static final AtomicIntegerFieldUpdater<SwitchTransformMain> ONCE = AtomicIntegerFieldUpdater.newUpdater(SwitchTransformMain.class, "once");

        SwitchTransformMain(CoreSubscriber<? super R> actual, BiFunction<T, Flux<T>, Publisher<? extends R>> transformer) {
            this.actual = actual;
            this.transformer = transformer;
            this.inner = new SwitchTransformInner(this);
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.s == Operators.cancelledSubscription();
            }
            if (key == Scannable.Attr.PREFETCH) {
                return 1;
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                s.request(1L);
            }
        }

        public void onNext(T t) {
            if (this.isCanceled()) {
                return;
            }
            if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
                try {
                    this.inner.first = t;
                    Publisher<? extends R> result = Objects.requireNonNull(this.transformer.apply(t, this.inner), "The transformer returned a null value");
                    result.subscribe(this.actual);
                    return;
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError((Subscription)this.s, (Throwable)e, t, (Context)this.actual.currentContext()));
                    ReferenceCountUtil.safeRelease(t);
                    return;
                }
            }
            this.inner.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.isCanceled()) {
                return;
            }
            if (this.once != 0) {
                this.inner.onError(t);
            } else {
                this.actual.onSubscribe(Operators.emptySubscription());
                this.actual.onError(t);
            }
        }

        public void onComplete() {
            if (this.isCanceled()) {
                return;
            }
            if (this.once != 0) {
                this.inner.onComplete();
            } else {
                this.actual.onSubscribe(Operators.emptySubscription());
                this.actual.onComplete();
            }
        }

        boolean isCanceled() {
            return this.s == Operators.cancelledSubscription();
        }

        void cancel() {
            this.s.cancel();
            this.s = Operators.cancelledSubscription();
        }
    }
}

