/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.rsocket.framing.CancelFrame;
import io.rsocket.framing.ErrorFrame;
import io.rsocket.framing.ExtensionFrame;
import io.rsocket.framing.Frame;
import io.rsocket.framing.FrameType;
import io.rsocket.framing.KeepaliveFrame;
import io.rsocket.framing.LeaseFrame;
import io.rsocket.framing.MetadataPushFrame;
import io.rsocket.framing.PayloadFrame;
import io.rsocket.framing.RequestChannelFrame;
import io.rsocket.framing.RequestFireAndForgetFrame;
import io.rsocket.framing.RequestNFrame;
import io.rsocket.framing.RequestResponseFrame;
import io.rsocket.framing.RequestStreamFrame;
import io.rsocket.framing.ResumeFrame;
import io.rsocket.framing.ResumeOkFrame;
import io.rsocket.framing.SetupFrame;
import java.util.Objects;

public final class FrameFactory {
    private FrameFactory() {
    }

    public static Frame createFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        FrameType frameType = FrameFactory.getFrameType(byteBuf);
        switch (frameType) {
            case SETUP: {
                return SetupFrame.createSetupFrame(byteBuf);
            }
            case LEASE: {
                return LeaseFrame.createLeaseFrame(byteBuf);
            }
            case KEEPALIVE: {
                return KeepaliveFrame.createKeepaliveFrame(byteBuf);
            }
            case REQUEST_RESPONSE: {
                return RequestResponseFrame.createRequestResponseFrame(byteBuf);
            }
            case REQUEST_FNF: {
                return RequestFireAndForgetFrame.createRequestFireAndForgetFrame(byteBuf);
            }
            case REQUEST_STREAM: {
                return RequestStreamFrame.createRequestStreamFrame(byteBuf);
            }
            case REQUEST_CHANNEL: {
                return RequestChannelFrame.createRequestChannelFrame(byteBuf);
            }
            case REQUEST_N: {
                return RequestNFrame.createRequestNFrame(byteBuf);
            }
            case CANCEL: {
                return CancelFrame.createCancelFrame(byteBuf);
            }
            case PAYLOAD: {
                return PayloadFrame.createPayloadFrame(byteBuf);
            }
            case ERROR: {
                return ErrorFrame.createErrorFrame(byteBuf);
            }
            case METADATA_PUSH: {
                return MetadataPushFrame.createMetadataPushFrame(byteBuf);
            }
            case RESUME: {
                return ResumeFrame.createResumeFrame(byteBuf);
            }
            case RESUME_OK: {
                return ResumeOkFrame.createResumeOkFrame(byteBuf);
            }
            case EXT: {
                return ExtensionFrame.createExtensionFrame(byteBuf);
            }
        }
        throw new IllegalArgumentException(String.format("Cannot create frame for type %s", new Object[]{frameType}));
    }

    private static FrameType getFrameType(ByteBuf byteBuf) {
        int encodedType = byteBuf.getUnsignedShort(0) >> 10;
        return FrameType.fromEncodedType(encodedType);
    }
}

