/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.surefire.junitcore.pc.ParallelComputerUtil;
import org.apache.maven.surefire.junitcore.pc.Scheduler;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategies;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.apache.maven.surefire.junitcore.pc.ShutdownResult;
import org.apache.maven.surefire.report.ConsoleStream;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;
import org.junit.runner.Description;
import org.junit.runners.model.RunnerScheduler;

final class SingleThreadScheduler {
    private final ConsoleStream logger;
    private final ExecutorService pool = SingleThreadScheduler.newPool();
    private final Scheduler master;

    private static ExecutorService newPool() {
        ThreadFactory tf = DaemonThreadFactory.newDaemonThreadFactory("maven-surefire-plugin@NotThreadSafe");
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), tf);
    }

    SingleThreadScheduler(ConsoleStream logger) {
        this.logger = logger;
        SchedulingStrategy strategy = SchedulingStrategies.createParallelSharedStrategy(logger, this.pool);
        this.master = new Scheduler(logger, null, strategy);
    }

    RunnerScheduler newRunnerScheduler() {
        SchedulingStrategy strategy = SchedulingStrategies.createParallelSharedStrategy(this.logger, this.pool);
        return new Scheduler(this.logger, null, this.master, strategy);
    }

    ShutdownResult describeStopped(boolean shutdownNow) {
        ShutdownResult shutdownResult = this.master.describeStopped(shutdownNow);
        return new ShutdownResult(this.copyExisting(shutdownResult.getTriggeredTests()), this.copyExisting(shutdownResult.getIncompleteTests()));
    }

    boolean shutdownThreadPoolsAwaitingKilled() {
        return this.master.shutdownThreadPoolsAwaitingKilled();
    }

    private Collection<Description> copyExisting(Collection<Description> descriptions) {
        ConcurrentLinkedQueue<Description> activeChildren = new ConcurrentLinkedQueue<Description>(descriptions);
        ParallelComputerUtil.removeUnusedDescriptions(activeChildren);
        return activeChildren;
    }
}

