/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.surefire.junitcore.pc.Destroyable;
import org.apache.maven.surefire.junitcore.pc.Scheduler;
import org.apache.maven.surefire.report.ConsoleStream;

public abstract class SchedulingStrategy
implements Destroyable {
    private final AtomicBoolean canSchedule = new AtomicBoolean(true);
    private final ConsoleStream logger;

    protected SchedulingStrategy(ConsoleStream logger) {
        this.logger = logger;
    }

    protected abstract void schedule(Runnable var1);

    protected abstract boolean finished() throws InterruptedException;

    protected abstract boolean stop();

    protected boolean stopNow() {
        return this.stop();
    }

    protected boolean disable() {
        return this.canSchedule.getAndSet(false);
    }

    protected void setDefaultShutdownHandler(Scheduler.ShutdownHandler handler) {
    }

    protected abstract boolean hasSharedThreadPool();

    protected boolean canSchedule() {
        return this.canSchedule.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logQuietly(Throwable t) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream stream = new PrintStream(out);){
            t.printStackTrace(stream);
            stream.flush();
        }
        this.logger.println(out.toString());
    }
}

