/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.maven.surefire.junitcore.pc.Balancer;
import org.apache.maven.surefire.junitcore.pc.BalancerFactory;
import org.apache.maven.surefire.junitcore.pc.ParallelComputerUtil;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.apache.maven.surefire.junitcore.pc.ShutdownResult;
import org.apache.maven.surefire.report.ConsoleStream;
import org.junit.runner.Description;
import org.junit.runners.model.RunnerScheduler;

public class Scheduler
implements RunnerScheduler {
    private final Balancer balancer;
    private final SchedulingStrategy strategy;
    private final Set<Controller> slaves = new CopyOnWriteArraySet<Controller>();
    private final Description description;
    private final ConsoleStream logger;
    private volatile boolean shutdown = false;
    private volatile boolean started = false;
    private volatile boolean finished = false;
    private volatile Controller masterController;

    public Scheduler(ConsoleStream logger, Description description, SchedulingStrategy strategy) {
        this(logger, description, strategy, -1);
    }

    public Scheduler(ConsoleStream logger, Description description, SchedulingStrategy strategy, int concurrency) {
        this(logger, description, strategy, BalancerFactory.createBalancer(concurrency));
    }

    public Scheduler(ConsoleStream logger, Description description, SchedulingStrategy strategy, Balancer balancer) {
        strategy.setDefaultShutdownHandler(this.newShutdownHandler());
        this.logger = logger;
        this.description = description;
        this.strategy = strategy;
        this.balancer = balancer;
        this.masterController = null;
    }

    public Scheduler(ConsoleStream logger, Description description, Scheduler masterScheduler, SchedulingStrategy strategy, Balancer balancer) {
        this(logger, description, strategy, balancer);
        strategy.setDefaultShutdownHandler(this.newShutdownHandler());
        masterScheduler.register(this);
    }

    public Scheduler(ConsoleStream logger, Description description, Scheduler masterScheduler, SchedulingStrategy strategy, int concurrency) {
        this(logger, description, strategy, concurrency);
        strategy.setDefaultShutdownHandler(this.newShutdownHandler());
        masterScheduler.register(this);
    }

    public Scheduler(ConsoleStream logger, Description description, Scheduler masterScheduler, SchedulingStrategy strategy) {
        this(logger, description, masterScheduler, strategy, 0);
    }

    private void setController(Controller masterController) {
        if (masterController == null) {
            throw new NullPointerException("null ExecutionController");
        }
        this.masterController = masterController;
    }

    private boolean register(Scheduler slave) {
        boolean canRegister;
        boolean bl = canRegister = slave != null && slave != this;
        if (canRegister) {
            Controller controller = new Controller(slave);
            boolean bl2 = canRegister = !this.slaves.contains(controller);
            if (canRegister) {
                this.slaves.add(controller);
                slave.setController(controller);
            }
        }
        return canRegister;
    }

    private boolean canSchedule() {
        return !this.shutdown && (this.masterController == null || this.masterController.canSchedule());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logQuietly(Throwable t) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream stream = new PrintStream(out);){
            t.printStackTrace(stream);
        }
        this.logger.println(out.toString());
    }

    protected void logQuietly(String msg) {
        this.logger.println(msg);
    }

    protected ShutdownResult describeStopped(boolean stopNow) {
        ConcurrentLinkedQueue<Description> executedTests = new ConcurrentLinkedQueue<Description>();
        ConcurrentLinkedQueue<Description> incompleteTests = new ConcurrentLinkedQueue<Description>();
        this.stop(executedTests, incompleteTests, false, stopNow);
        return new ShutdownResult(executedTests, incompleteTests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(Collection<Description> executedTests, Collection<Description> incompleteTests, boolean tryCancelFutures, boolean stopNow) {
        this.shutdown = true;
        try {
            if (this.started && !ParallelComputerUtil.isUnusedDescription(this.description)) {
                if (executedTests != null) {
                    executedTests.add(this.description);
                }
                if (incompleteTests != null && !this.finished) {
                    incompleteTests.add(this.description);
                }
            }
            for (Controller slave : this.slaves) {
                slave.stop(executedTests, incompleteTests, tryCancelFutures, stopNow);
            }
        }
        finally {
            try {
                this.balancer.releaseAllPermits();
            }
            finally {
                if (stopNow) {
                    this.strategy.stopNow();
                } else if (tryCancelFutures) {
                    this.strategy.stop();
                } else {
                    this.strategy.disable();
                }
            }
        }
    }

    protected boolean shutdownThreadPoolsAwaitingKilled() {
        if (this.masterController == null) {
            this.stop(null, null, true, false);
            boolean isNotInterrupted = true;
            if (this.strategy != null) {
                isNotInterrupted = this.strategy.destroy();
            }
            for (Controller slave : this.slaves) {
                isNotInterrupted &= slave.destroy();
            }
            return isNotInterrupted;
        }
        throw new UnsupportedOperationException("cannot call this method if this is not a master scheduler");
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    @Override
    public void schedule(Runnable childStatement) {
        if (childStatement == null) {
            this.logQuietly("cannot schedule null");
        } else if (this.canSchedule() && this.strategy.canSchedule()) {
            try {
                boolean isNotInterrupted = this.balancer.acquirePermit();
                if (isNotInterrupted && !this.shutdown) {
                    Runnable task = this.wrapTask(childStatement);
                    this.strategy.schedule(task);
                    this.started = true;
                }
            }
            catch (RejectedExecutionException e) {
                this.stop(null, null, true, false);
            }
            catch (Throwable t) {
                this.balancer.releasePermit();
                this.logQuietly(t);
            }
        }
    }

    @Override
    public void finished() {
        try {
            this.strategy.finished();
        }
        catch (InterruptedException e) {
            this.logQuietly(e);
        }
        finally {
            this.finished = true;
        }
    }

    private Runnable wrapTask(final Runnable task) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Scheduler.this.beforeExecute();
                    task.run();
                }
                finally {
                    try {
                        Scheduler.this.afterExecute();
                    }
                    finally {
                        Scheduler.this.balancer.releasePermit();
                    }
                }
            }
        };
    }

    protected ShutdownHandler newShutdownHandler() {
        return new ShutdownHandler();
    }

    public class ShutdownHandler
    implements RejectedExecutionHandler {
        private volatile RejectedExecutionHandler poolHandler = null;

        protected ShutdownHandler() {
        }

        public void setRejectedExecutionHandler(RejectedExecutionHandler poolHandler) {
            this.poolHandler = poolHandler;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            RejectedExecutionHandler poolHandler;
            if (executor.isShutdown()) {
                Scheduler.this.stop(null, null, true, false);
            }
            if ((poolHandler = this.poolHandler) != null) {
                poolHandler.rejectedExecution(r, executor);
            }
        }
    }

    private final class Controller {
        private final Scheduler slave;

        private Controller(Scheduler slave) {
            this.slave = slave;
        }

        boolean canSchedule() {
            return Scheduler.this.canSchedule();
        }

        void stop(Collection<Description> executedTests, Collection<Description> incompleteTests, boolean tryCancelFutures, boolean shutdownNow) {
            this.slave.stop(executedTests, incompleteTests, tryCancelFutures, shutdownNow);
        }

        boolean destroy() {
            return this.slave.strategy.destroy();
        }

        public int hashCode() {
            return this.slave.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Controller && this.slave.equals(((Controller)o).slave);
        }
    }
}

