/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import org.apache.maven.surefire.NonAbstractClassFilter;
import org.apache.maven.surefire.common.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.util.ScannerFilter;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

public class JUnit48TestChecker
implements ScannerFilter {
    private final NonAbstractClassFilter nonAbstractClassFilter;
    private final JUnit4TestChecker jUnit4TestChecker;

    public JUnit48TestChecker(ClassLoader testClassLoader) {
        this.jUnit4TestChecker = new JUnit4TestChecker(testClassLoader);
        this.nonAbstractClassFilter = new NonAbstractClassFilter();
    }

    @Override
    public boolean accept(Class testClass) {
        return this.jUnit4TestChecker.accept(testClass) || this.isAbstractWithEnclosedRunner(testClass);
    }

    private boolean isAbstractWithEnclosedRunner(Class testClass) {
        return this.jUnit4TestChecker.isRunWithPresentInClassLoader() && this.isAbstract(testClass) && this.isRunWithEnclosedRunner(testClass);
    }

    private boolean isRunWithEnclosedRunner(Class testClass) {
        RunWith runWithAnnotation = testClass.getAnnotation(RunWith.class);
        return runWithAnnotation != null && Enclosed.class.equals(runWithAnnotation.value());
    }

    private boolean isAbstract(Class testClass) {
        return !this.nonAbstractClassFilter.accept(testClass);
    }
}

