/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import org.apache.maven.surefire.util.ReflectionUtils;

public final class JUnit48Reflector {
    private static final String CATEGORIES = "org.junit.experimental.categories.Categories";
    private static final String CATEGORY = "org.junit.experimental.categories.Category";
    private final Class<?> categories;
    private final Class<?> category;

    public JUnit48Reflector(ClassLoader testClassLoader) {
        this.categories = ReflectionUtils.tryLoadClass(testClassLoader, CATEGORIES);
        this.category = ReflectionUtils.tryLoadClass(testClassLoader, CATEGORY);
    }

    public boolean isJUnit48Available() {
        return this.categories != null;
    }

    boolean isCategoryAnnotationPresent(Class clazz) {
        return clazz != null && this.category != null && (clazz.getAnnotation(this.category) != null || this.isCategoryAnnotationPresent(clazz.getSuperclass()));
    }
}

