/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.surefire.group.match.AndGroupMatcher;
import org.apache.maven.surefire.group.match.GroupMatcher;
import org.apache.maven.surefire.group.match.InverseGroupMatcher;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

final class GroupMatcherCategoryFilter
extends Filter {
    private final AndGroupMatcher matcher;

    GroupMatcherCategoryFilter(GroupMatcher included, GroupMatcher excluded) {
        InverseGroupMatcher invertedExclude;
        InverseGroupMatcher inverseGroupMatcher = invertedExclude = excluded == null ? null : new InverseGroupMatcher(excluded);
        if (included != null || invertedExclude != null) {
            this.matcher = new AndGroupMatcher(new GroupMatcher[0]);
            if (included != null) {
                this.matcher.addMatcher(included);
            }
            if (invertedExclude != null) {
                this.matcher.addMatcher(invertedExclude);
            }
        } else {
            this.matcher = null;
        }
    }

    @Override
    public boolean shouldRun(Description description) {
        if (description.getMethodName() == null || description.getTestClass() == null) {
            return this.shouldRun(description, null, null);
        }
        Class<?> testClass = description.getTestClass();
        return this.shouldRun(description, Description.createSuiteDescription(testClass), testClass);
    }

    private static void findSuperclassCategories(Set<Class<?>> cats, Class<?> clazz) {
        if (clazz != null && clazz.getSuperclass() != null) {
            Category cat = clazz.getSuperclass().getAnnotation(Category.class);
            if (cat != null) {
                Collections.addAll(cats, cat.value());
            } else {
                GroupMatcherCategoryFilter.findSuperclassCategories(cats, clazz.getSuperclass());
            }
        }
    }

    private boolean shouldRun(Description description, Description parent, Class<?> parentClass) {
        ArrayList<Description> children;
        Class<?> testClass;
        if (this.matcher == null) {
            return true;
        }
        HashSet cats = new HashSet();
        Category cat = description.getAnnotation(Category.class);
        if (cat != null) {
            Collections.addAll(cats, cat.value());
        }
        if (parent != null && (cat = parent.getAnnotation(Category.class)) != null) {
            Collections.addAll(cats, cat.value());
        }
        if (parentClass != null) {
            GroupMatcherCategoryFilter.findSuperclassCategories(cats, parentClass);
        }
        if ((testClass = description.getTestClass()) != null && (cat = testClass.getAnnotation(Category.class)) != null) {
            Collections.addAll(cats, cat.value());
        }
        cats.remove(null);
        boolean result = this.matcher.enabled(cats.toArray(new Class[cats.size()]));
        if (!result && (children = description.getChildren()) != null) {
            for (Description child : children) {
                if (!this.shouldRun(child, description, null)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public String describe() {
        return this.matcher == null ? "ANY" : this.matcher.toString();
    }
}

