/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import java.util.Map;
import java.util.Set;
import org.apache.maven.surefire.common.junit48.AndFilter;
import org.apache.maven.surefire.common.junit48.FailingMethodFilter;
import org.apache.maven.surefire.common.junit48.GroupMatcherCategoryFilter;
import org.apache.maven.surefire.common.junit48.MethodFilter;
import org.apache.maven.surefire.group.match.GroupMatcher;
import org.apache.maven.surefire.group.parse.GroupMatcherParser;
import org.apache.maven.surefire.group.parse.ParseException;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.junit.runner.manipulation.Filter;

public class FilterFactory {
    private final ClassLoader testClassLoader;

    public FilterFactory(ClassLoader testClassLoader) {
        this.testClassLoader = testClassLoader;
    }

    public boolean canCreateGroupFilter(Map<String, String> providerProperties) {
        String groups = providerProperties.get("groups");
        String excludedGroups = providerProperties.get("excludegroups");
        return StringUtils.isNotBlank(groups) || StringUtils.isNotBlank(excludedGroups);
    }

    public Filter createGroupFilter(Map<String, String> providerProperties) {
        String groups = providerProperties.get("groups");
        GroupMatcher included = null;
        if (StringUtils.isNotBlank(groups)) {
            try {
                included = new GroupMatcherParser(groups).parse();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid group expression: '" + groups + "'. Reason: " + e.getMessage(), e);
            }
        }
        String excludedGroups = providerProperties.get("excludegroups");
        GroupMatcher excluded = null;
        if (StringUtils.isNotBlank(excludedGroups)) {
            try {
                excluded = new GroupMatcherParser(excludedGroups).parse();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid group expression: '" + excludedGroups + "'. Reason: " + e.getMessage(), e);
            }
        }
        if (included != null && this.testClassLoader != null) {
            included.loadGroupClasses(this.testClassLoader);
        }
        if (excluded != null && this.testClassLoader != null) {
            excluded.loadGroupClasses(this.testClassLoader);
        }
        return new GroupMatcherCategoryFilter(included, excluded);
    }

    public Filter createMethodFilter(String requestedTestMethod) {
        return new MethodFilter(requestedTestMethod);
    }

    public Filter createMethodFilter(TestListResolver resolver) {
        return new MethodFilter(resolver);
    }

    public Filter createFailingMethodFilter(Map<Class<?>, Set<String>> failingClassMethodMap) {
        return new FailingMethodFilter(failingClassMethodMap);
    }

    public Filter and(Filter filter1, Filter filter2) {
        return new AndFilter(filter1, filter2);
    }
}

