/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import java.util.Collection;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

final class CombinedCategoryFilter
extends Filter {
    private final Collection<Filter> includedFilters;
    private final Collection<Filter> excludedFilters;

    CombinedCategoryFilter(Collection<Filter> includedFilters, Collection<Filter> excludedFilters) {
        this.includedFilters = includedFilters;
        this.excludedFilters = excludedFilters;
    }

    @Override
    public boolean shouldRun(Description description) {
        return !(!this.includedFilters.isEmpty() && !this.anyFilterMatchesDescription(this.includedFilters, description) || !this.excludedFilters.isEmpty() && !this.allFiltersMatchDescription(this.excludedFilters, description));
    }

    private boolean anyFilterMatchesDescription(Collection<Filter> filters, Description description) {
        for (Filter f : filters) {
            if (!f.shouldRun(description)) continue;
            return true;
        }
        return false;
    }

    private boolean allFiltersMatchDescription(Collection<Filter> filters, Description description) {
        for (Filter f : filters) {
            if (f.shouldRun(description)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String describe() {
        StringBuilder sb = new StringBuilder();
        if (!this.includedFilters.isEmpty()) {
            sb.append("(");
            sb.append(this.joinFilters(this.includedFilters, " OR "));
            sb.append(")");
            if (!this.excludedFilters.isEmpty()) {
                sb.append(" AND ");
            }
        }
        if (!this.excludedFilters.isEmpty()) {
            sb.append("NOT (");
            sb.append(this.joinFilters(this.includedFilters, " OR "));
            sb.append(")");
        }
        return sb.toString();
    }

    private String joinFilters(Collection<Filter> filters, String sep) {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (Filter f : filters) {
            if (!isFirst) {
                sb.append(sep);
            }
            sb.append(f.describe());
            isFirst = false;
        }
        return sb.toString();
    }
}

