/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.SmartStackTraceParser;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.util.internal.TestClassMethodNameUtils;
import org.junit.runner.notification.Failure;

public class JUnit4StackTraceWriter
implements StackTraceWriter {
    protected final Failure junitFailure;

    public JUnit4StackTraceWriter(Failure junitFailure) {
        this.junitFailure = junitFailure;
    }

    @Override
    public String writeTraceToString() {
        Throwable t = this.junitFailure.getException();
        if (t != null) {
            String originalTrace = this.junitFailure.getTrace();
            if (JUnit4StackTraceWriter.isMultiLineExceptionMessage(t)) {
                StringBuilder builder = new StringBuilder(originalTrace);
                String exc = t.getClass().getName() + ": ";
                if (originalTrace.startsWith(exc)) {
                    builder.insert(exc.length(), '\n');
                }
                return builder.toString();
            }
            return originalTrace;
        }
        return "";
    }

    protected String getTestClassName() {
        return TestClassMethodNameUtils.extractClassName(this.junitFailure.getDescription().getDisplayName());
    }

    protected String getTestMethodName() {
        return TestClassMethodNameUtils.extractMethodName(this.junitFailure.getDescription().getDisplayName());
    }

    @Override
    public String smartTrimmedStackTrace() {
        Throwable exception = this.junitFailure.getException();
        return exception == null ? this.junitFailure.getMessage() : new SmartStackTraceParser(this.getTestClassName(), exception, this.getTestMethodName()).getString();
    }

    @Override
    public String writeTrimmedTraceToString() {
        String testClass = this.getTestClassName();
        try {
            Throwable e = this.junitFailure.getException();
            return SmartStackTraceParser.stackTraceWithFocusOnClassAsString(e, testClass);
        }
        catch (Throwable t) {
            return SmartStackTraceParser.stackTraceWithFocusOnClassAsString(t, testClass);
        }
    }

    @Override
    public SafeThrowable getThrowable() {
        return new SafeThrowable(this.junitFailure.getException());
    }

    private static boolean isMultiLineExceptionMessage(Throwable t) {
        String msg = t.getLocalizedMessage();
        if (msg != null) {
            int countNewLines = 0;
            int length = msg.length();
            for (int i = 0; i < length && (msg.charAt(i) != '\n' || ++countNewLines != 2); ++i) {
            }
            return countNewLines > 1 || countNewLines == 1 && !msg.trim().endsWith("\n");
        }
        return false;
    }
}

