/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4StackTraceWriter;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.internal.TestClassMethodNameUtils;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4RunListener
extends RunListener {
    protected final org.apache.maven.surefire.report.RunListener reporter;
    private final ThreadLocal<Boolean> failureFlag = new InheritableThreadLocal<Boolean>();

    public JUnit4RunListener(org.apache.maven.surefire.report.RunListener reporter) {
        this.reporter = reporter;
    }

    @Override
    public void testIgnored(Description description) throws Exception {
        String reason = JUnit4Reflector.getAnnotatedIgnoreValue(description);
        this.reporter.testSkipped(SimpleReportEntry.ignored(this.getClassName(description), description.getDisplayName(), reason));
    }

    @Override
    public void testStarted(Description description) throws Exception {
        try {
            this.reporter.testStarting(this.createReportEntry(description));
        }
        finally {
            this.failureFlag.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testFailure(Failure failure) throws Exception {
        try {
            String testHeader = failure.getTestHeader();
            if (JUnit4RunListener.isInsaneJunitNullString(testHeader)) {
                testHeader = "Failure when constructing test";
            }
            String testClassName = this.getClassName(failure.getDescription());
            StackTraceWriter stackTrace = this.createStackTraceWriter(failure);
            SimpleReportEntry report = SimpleReportEntry.withException(testClassName, testHeader, stackTrace);
            if (failure.getException() instanceof AssertionError) {
                this.reporter.testFailed(report);
            } else {
                this.reporter.testError(report);
            }
        }
        finally {
            this.failureFlag.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testAssumptionFailure(Failure failure) {
        try {
            Description desc = failure.getDescription();
            String test = this.getClassName(desc);
            this.reporter.testAssumptionFailure(SimpleReportEntry.assumption(test, desc.getDisplayName(), failure.getMessage()));
        }
        finally {
            this.failureFlag.set(true);
        }
    }

    @Override
    public void testFinished(Description description) throws Exception {
        Boolean failure = this.failureFlag.get();
        if (failure == null) {
            this.reporter.testSucceeded(this.createReportEntry(description));
        }
    }

    public void testExecutionSkippedByUser() {
        this.reporter.testExecutionSkippedByUser();
    }

    private String getClassName(Description description) {
        String name = this.extractDescriptionClassName(description);
        if (name == null || JUnit4RunListener.isInsaneJunitNullString(name)) {
            Description subDescription = description.getChildren().get(0);
            if (subDescription != null) {
                name = this.extractDescriptionClassName(subDescription);
            }
            if (name == null) {
                name = "Test Instantiation Error";
            }
        }
        return name;
    }

    protected StackTraceWriter createStackTraceWriter(Failure failure) {
        return new JUnit4StackTraceWriter(failure);
    }

    protected SimpleReportEntry createReportEntry(Description description) {
        return new SimpleReportEntry(this.getClassName(description), description.getDisplayName());
    }

    protected String extractDescriptionClassName(Description description) {
        return TestClassMethodNameUtils.extractClassName(description.getDisplayName());
    }

    protected String extractDescriptionMethodName(Description description) {
        return TestClassMethodNameUtils.extractMethodName(description.getDisplayName());
    }

    public static void rethrowAnyTestMechanismFailures(Result run) throws TestSetFailedException {
        for (Failure failure : run.getFailures()) {
            if (!JUnit4ProviderUtil.isFailureInsideJUnitItself(failure.getDescription())) continue;
            throw new TestSetFailedException(failure.getTestHeader() + " :: " + failure.getMessage(), failure.getException());
        }
    }

    private static boolean isInsaneJunitNullString(String value) {
        return "null".equals(value);
    }
}

