/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.SurefireReflectionException;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Request;

public final class JUnit4Reflector {
    private static final Class[] PARAMS = new Class[]{Class.class};
    private static final Class[] IGNORE_PARAMS = new Class[]{Ignore.class};
    private static final Class[] PARAMS_WITH_ANNOTATIONS = new Class[]{String.class, Annotation[].class};

    private JUnit4Reflector() {
        throw new IllegalStateException("not instantiable constructor");
    }

    public static Ignore getAnnotatedIgnore(Description d) {
        Method getAnnotation = ReflectionUtils.tryGetMethod(d.getClass(), "getAnnotation", PARAMS);
        return getAnnotation == null ? null : (Ignore)ReflectionUtils.invokeMethodWithArray(d, getAnnotation, IGNORE_PARAMS);
    }

    public static String getAnnotatedIgnoreValue(Description description) {
        Ignore ignore = JUnit4Reflector.getAnnotatedIgnore(description);
        return ignore != null ? ignore.value() : null;
    }

    public static Request createRequest(Class<?> ... classes) {
        try {
            return (Request)Request.class.getDeclaredMethod("classes", Class[].class).invoke(null, new Object[]{classes});
        }
        catch (NoSuchMethodException e) {
            return Request.classes(null, (Class[])classes);
        }
        catch (InvocationTargetException e) {
            throw new SurefireReflectionException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Description createDescription(String description) {
        try {
            return Description.createSuiteDescription((String)description);
        }
        catch (NoSuchMethodError e) {
            Method method = ReflectionUtils.tryGetMethod(Description.class, "createSuiteDescription", PARAMS_WITH_ANNOTATIONS);
            return (Description)ReflectionUtils.invokeMethodWithArray(null, method, description, new Annotation[0]);
        }
    }

    public static Description createDescription(String description, Annotation ... annotations) {
        Method method = ReflectionUtils.tryGetMethod(Description.class, "createSuiteDescription", PARAMS_WITH_ANNOTATIONS);
        return method == null ? Description.createSuiteDescription((String)description) : (Description)ReflectionUtils.invokeMethodWithArray(null, method, description, annotations);
    }

    public static Ignore createIgnored(String value) {
        return new IgnoredWithUserError(value);
    }

    private static class IgnoredWithUserError
    implements Annotation,
    Ignore {
        private final String value;

        public IgnoredWithUserError(String value) {
            this.value = value;
        }

        public IgnoredWithUserError() {
            this("");
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Ignore.class;
        }

        @Override
        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Annotation && obj instanceof Ignore && this.equalValue((Ignore)obj);
        }

        @Override
        public String toString() {
            return String.format("%s(%s)", Ignore.class, this.value);
        }

        private boolean equalValue(Ignore ignore) {
            if (ignore == null) {
                return false;
            }
            String val = ignore.value();
            return val == null ? this.value == null : val.equals(this.value);
        }
    }
}

