/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit3;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.maven.surefire.util.ReflectionUtils;

public final class JUnit3Reflector {
    private static final String TEST_CASE = "junit.framework.Test";
    private static final String TEST_RESULT = "junit.framework.TestResult";
    private static final String TEST_LISTENER = "junit.framework.TestListener";
    private static final String TEST = "junit.framework.Test";
    private static final String ADD_LISTENER_METHOD = "addListener";
    private static final String RUN_METHOD = "run";
    private static final String TEST_SUITE = "junit.framework.TestSuite";
    private final Class[] interfacesImplementedByDynamicProxy;
    private final Class<?> testResultClass;
    private final Method addListenerMethod;
    private final Method testInterfaceRunMethod;
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Class<?> testInterface;
    private final Class<?> testCase;
    private final Constructor testsSuiteConstructor;

    public JUnit3Reflector(ClassLoader testClassLoader) {
        this.testResultClass = ReflectionUtils.tryLoadClass(testClassLoader, TEST_RESULT);
        this.testCase = ReflectionUtils.tryLoadClass(testClassLoader, "junit.framework.Test");
        this.testInterface = ReflectionUtils.tryLoadClass(testClassLoader, "junit.framework.Test");
        this.interfacesImplementedByDynamicProxy = new Class[]{ReflectionUtils.tryLoadClass(testClassLoader, TEST_LISTENER)};
        Class[] constructorParamTypes = new Class[]{Class.class};
        Class<?> testSuite = ReflectionUtils.tryLoadClass(testClassLoader, TEST_SUITE);
        Class[] addListenerParamTypes = this.interfacesImplementedByDynamicProxy;
        if (this.isJUnit3Available()) {
            this.testsSuiteConstructor = ReflectionUtils.getConstructor(testSuite, constructorParamTypes);
            this.addListenerMethod = JUnit3Reflector.tryGetMethod(this.testResultClass, ADD_LISTENER_METHOD, addListenerParamTypes);
            this.testInterfaceRunMethod = JUnit3Reflector.getMethod(this.testInterface, RUN_METHOD, this.testResultClass);
        } else {
            this.testsSuiteConstructor = null;
            this.addListenerMethod = null;
            this.testInterfaceRunMethod = null;
        }
    }

    private static Method tryGetMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            return clazz.getMethod(methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            return clazz.getMethod(methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("When finding method " + methodName, e);
        }
    }

    public Object constructTestObject(Class testClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Object testObject = JUnit3Reflector.createInstanceFromSuiteMethod(testClass);
        if (testObject == null && this.testCase.isAssignableFrom(testClass)) {
            testObject = this.testsSuiteConstructor.newInstance(testClass);
        }
        if (testObject == null) {
            Constructor testConstructor = JUnit3Reflector.getTestConstructor(testClass);
            testObject = testConstructor.getParameterTypes().length == 0 ? testConstructor.newInstance(EMPTY_OBJECT_ARRAY) : testConstructor.newInstance(testClass.getName());
        }
        return testObject;
    }

    private static Object createInstanceFromSuiteMethod(Class<?> testClass) throws IllegalAccessException, InvocationTargetException {
        Object testObject = null;
        try {
            Method suiteMethod = testClass.getMethod("suite", EMPTY_CLASS_ARRAY);
            if (Modifier.isPublic(suiteMethod.getModifiers()) && Modifier.isStatic(suiteMethod.getModifiers())) {
                testObject = suiteMethod.invoke(null, (Object[])EMPTY_CLASS_ARRAY);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return testObject;
    }

    private static Constructor getTestConstructor(Class<?> testClass) throws NoSuchMethodException {
        try {
            return testClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            return testClass.getConstructor(EMPTY_CLASS_ARRAY);
        }
    }

    public Class[] getInterfacesImplementedByDynamicProxy() {
        return this.interfacesImplementedByDynamicProxy;
    }

    public Class<?> getTestResultClass() {
        return this.testResultClass;
    }

    public Method getAddListenerMethod() {
        return this.addListenerMethod;
    }

    public Method getTestInterfaceRunMethod() {
        return this.testInterfaceRunMethod;
    }

    public Class<?> getTestInterface() {
        return this.testInterface;
    }

    public Method getRunMethod(Class<?> testClass) {
        return JUnit3Reflector.getMethod(testClass, RUN_METHOD, this.getTestResultClass());
    }

    public boolean isJUnit3Available() {
        return this.testResultClass != null;
    }
}

