/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.ReporterUtils;
import org.apache.maven.plugin.surefire.report.Utf8RecodingDeferredFileOutputStream;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.report.TestSetReportEntry;
import org.apache.maven.surefire.util.internal.StringUtils;

public class WrappedReportEntry
implements TestSetReportEntry {
    private final ReportEntry original;
    private final ReportEntryType reportEntryType;
    private final Integer elapsed;
    private final Utf8RecodingDeferredFileOutputStream stdout;
    private final Utf8RecodingDeferredFileOutputStream stdErr;
    private final Map<String, String> systemProperties;

    public WrappedReportEntry(ReportEntry original, ReportEntryType reportEntryType, Integer estimatedElapsed, Utf8RecodingDeferredFileOutputStream stdout, Utf8RecodingDeferredFileOutputStream stdErr, Map<String, String> systemProperties) {
        this.original = original;
        this.reportEntryType = reportEntryType;
        this.elapsed = estimatedElapsed;
        this.stdout = stdout;
        this.stdErr = stdErr;
        this.systemProperties = Collections.unmodifiableMap(systemProperties);
    }

    public WrappedReportEntry(ReportEntry original, ReportEntryType reportEntryType, Integer estimatedElapsed, Utf8RecodingDeferredFileOutputStream stdout, Utf8RecodingDeferredFileOutputStream stdErr) {
        this(original, reportEntryType, estimatedElapsed, stdout, stdErr, Collections.emptyMap());
    }

    @Override
    public Integer getElapsed() {
        return this.elapsed;
    }

    public ReportEntryType getReportEntryType() {
        return this.reportEntryType;
    }

    public Utf8RecodingDeferredFileOutputStream getStdout() {
        return this.stdout;
    }

    public Utf8RecodingDeferredFileOutputStream getStdErr() {
        return this.stdErr;
    }

    @Override
    public String getSourceName() {
        return this.original.getSourceName();
    }

    @Override
    public String getName() {
        return this.original.getName();
    }

    public String getClassMethodName() {
        return this.getSourceName() + "." + this.getName();
    }

    @Override
    public String getGroup() {
        return this.original.getGroup();
    }

    @Override
    public StackTraceWriter getStackTraceWriter() {
        return this.original.getStackTraceWriter();
    }

    @Override
    public String getMessage() {
        return this.original.getMessage();
    }

    public String getStackTrace(boolean trimStackTrace) {
        StackTraceWriter w = this.original.getStackTraceWriter();
        return w == null ? null : (trimStackTrace ? w.writeTrimmedTraceToString() : w.writeTraceToString());
    }

    public String elapsedTimeAsString() {
        return this.elapsedTimeAsString(this.getElapsed().intValue());
    }

    String elapsedTimeAsString(long runTime) {
        return ReporterUtils.formatElapsedTime(runTime);
    }

    public String getReportName() {
        int i = this.getName().lastIndexOf("(");
        return i > 0 ? this.getName().substring(0, i) : this.getName();
    }

    public String getReportName(String suffix) {
        return suffix != null && !suffix.isEmpty() ? this.getReportName() + "(" + suffix + ")" : this.getReportName();
    }

    public String getOutput(boolean trimStackTrace) {
        return this.getElapsedTimeSummary() + "  <<< " + this.getReportEntryType().toString().toUpperCase() + "!" + StringUtils.NL + this.getStackTrace(trimStackTrace);
    }

    public String getElapsedTimeVerbose() {
        return "Time elapsed: " + this.elapsedTimeAsString() + " s";
    }

    public String getElapsedTimeSummary() {
        return this.getName() + "  " + this.getElapsedTimeVerbose();
    }

    public boolean isErrorOrFailure() {
        ReportEntryType thisType = this.getReportEntryType();
        return ReportEntryType.FAILURE == thisType || ReportEntryType.ERROR == thisType;
    }

    public boolean isSkipped() {
        return ReportEntryType.SKIPPED == this.getReportEntryType();
    }

    public boolean isSucceeded() {
        return ReportEntryType.SUCCESS == this.getReportEntryType();
    }

    @Override
    public String getNameWithGroup() {
        return this.original.getNameWithGroup();
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }
}

