/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.plugin.surefire.report.FileReporterUtils;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.Utf8RecodingDeferredFileOutputStream;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.shade.org.apache.commons.io.IOUtils;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.xml.PrettyPrintXMLWriter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.xml.XMLWriter;
import org.apache.maven.surefire.util.internal.StringUtils;

public class StatelessXmlReporter {
    private final File reportsDirectory;
    private final String reportNameSuffix;
    private final boolean trimStackTrace;
    private final int rerunFailingTestsCount;
    private final String xsdSchemaLocation;
    private final Map<String, Map<String, List<WrappedReportEntry>>> testClassMethodRunHistoryMap;

    public StatelessXmlReporter(File reportsDirectory, String reportNameSuffix, boolean trimStackTrace, int rerunFailingTestsCount, Map<String, Map<String, List<WrappedReportEntry>>> testClassMethodRunHistoryMap, String xsdSchemaLocation) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
        this.trimStackTrace = trimStackTrace;
        this.rerunFailingTestsCount = rerunFailingTestsCount;
        this.testClassMethodRunHistoryMap = testClassMethodRunHistoryMap;
        this.xsdSchemaLocation = xsdSchemaLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void testSetCompleted(WrappedReportEntry testSetReportEntry, TestSetStats testSetStats) {
        String testClassName = testSetReportEntry.getName();
        Map<String, List<WrappedReportEntry>> methodRunHistoryMap = this.getAddMethodRunHistoryMap(testClassName);
        for (WrappedReportEntry methodEntry : testSetStats.getReportEntries()) {
            StatelessXmlReporter.getAddMethodEntryList(methodRunHistoryMap, methodEntry);
        }
        OutputStream outputStream = this.getOutputStream(testSetReportEntry);
        OutputStreamWriter fw = StatelessXmlReporter.getWriter(outputStream);
        try {
            PrettyPrintXMLWriter ppw = new PrettyPrintXMLWriter(fw);
            ppw.setEncoding(StringUtils.UTF_8.name());
            this.createTestSuiteElement(ppw, testSetReportEntry, testSetStats, testSetReportEntry.elapsedTimeAsString());
            StatelessXmlReporter.showProperties(ppw, testSetReportEntry.getSystemProperties());
            block10: for (Map.Entry<String, List<WrappedReportEntry>> entry : methodRunHistoryMap.entrySet()) {
                List<WrappedReportEntry> methodEntryList = entry.getValue();
                if (methodEntryList == null) {
                    throw new IllegalStateException("Get null test method run history");
                }
                if (methodEntryList.isEmpty()) continue;
                if (this.rerunFailingTestsCount > 0) {
                    DefaultReporterFactory.TestResultType resultType = this.getTestResultType(methodEntryList);
                    switch (resultType) {
                        case success: {
                            for (WrappedReportEntry wrappedReportEntry : methodEntryList) {
                                if (wrappedReportEntry.getReportEntryType() != ReportEntryType.SUCCESS) continue;
                                StatelessXmlReporter.startTestElement(ppw, wrappedReportEntry, this.reportNameSuffix, methodEntryList.get(0).elapsedTimeAsString());
                                ppw.endElement();
                            }
                            continue block10;
                        }
                        case error: 
                        case failure: {
                            StatelessXmlReporter.startTestElement(ppw, methodEntryList.get(0), this.reportNameSuffix, methodEntryList.get(0).elapsedTimeAsString());
                            boolean firstRun = true;
                            for (WrappedReportEntry singleRunEntry : methodEntryList) {
                                if (firstRun) {
                                    firstRun = false;
                                    StatelessXmlReporter.getTestProblems(fw, ppw, singleRunEntry, this.trimStackTrace, outputStream, singleRunEntry.getReportEntryType().getXmlTag(), false);
                                    StatelessXmlReporter.createOutErrElements(fw, ppw, singleRunEntry, outputStream);
                                    continue;
                                }
                                StatelessXmlReporter.getTestProblems(fw, ppw, singleRunEntry, this.trimStackTrace, outputStream, singleRunEntry.getReportEntryType().getRerunXmlTag(), true);
                            }
                            ppw.endElement();
                            break;
                        }
                        case flake: {
                            void var13_19;
                            String string = "";
                            for (WrappedReportEntry singleRunEntry : methodEntryList) {
                                if (singleRunEntry.getReportEntryType() != ReportEntryType.SUCCESS) continue;
                                String string2 = singleRunEntry.elapsedTimeAsString();
                                break;
                            }
                            StatelessXmlReporter.startTestElement(ppw, methodEntryList.get(0), this.reportNameSuffix, (String)var13_19);
                            for (WrappedReportEntry singleRunEntry : methodEntryList) {
                                if (singleRunEntry.getReportEntryType() == ReportEntryType.SUCCESS) continue;
                                StatelessXmlReporter.getTestProblems(fw, ppw, singleRunEntry, this.trimStackTrace, outputStream, singleRunEntry.getReportEntryType().getFlakyXmlTag(), true);
                            }
                            ppw.endElement();
                            break;
                        }
                        case skipped: {
                            StatelessXmlReporter.startTestElement(ppw, methodEntryList.get(0), this.reportNameSuffix, methodEntryList.get(0).elapsedTimeAsString());
                            StatelessXmlReporter.getTestProblems(fw, ppw, methodEntryList.get(0), this.trimStackTrace, outputStream, methodEntryList.get(0).getReportEntryType().getXmlTag(), false);
                            ppw.endElement();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Get unknown test result type");
                        }
                    }
                    continue;
                }
                for (WrappedReportEntry methodEntry : methodEntryList) {
                    StatelessXmlReporter.startTestElement(ppw, methodEntry, this.reportNameSuffix, methodEntry.elapsedTimeAsString());
                    if (methodEntry.getReportEntryType() != ReportEntryType.SUCCESS) {
                        StatelessXmlReporter.getTestProblems(fw, ppw, methodEntry, this.trimStackTrace, outputStream, methodEntry.getReportEntryType().getXmlTag(), false);
                        StatelessXmlReporter.createOutErrElements(fw, ppw, methodEntry, outputStream);
                    }
                    ppw.endElement();
                }
            }
            ppw.endElement();
        }
        finally {
            IOUtils.closeQuietly(fw);
        }
    }

    public void cleanTestHistoryMap() {
        this.testClassMethodRunHistoryMap.clear();
    }

    private DefaultReporterFactory.TestResultType getTestResultType(List<WrappedReportEntry> methodEntryList) {
        ArrayList<ReportEntryType> testResultTypeList = new ArrayList<ReportEntryType>();
        for (WrappedReportEntry singleRunEntry : methodEntryList) {
            testResultTypeList.add(singleRunEntry.getReportEntryType());
        }
        return DefaultReporterFactory.getTestResultType(testResultTypeList, this.rerunFailingTestsCount);
    }

    private Map<String, List<WrappedReportEntry>> getAddMethodRunHistoryMap(String testClassName) {
        Map<String, List<WrappedReportEntry>> methodRunHistoryMap = this.testClassMethodRunHistoryMap.get(testClassName);
        if (methodRunHistoryMap == null) {
            methodRunHistoryMap = Collections.synchronizedMap(new LinkedHashMap());
            this.testClassMethodRunHistoryMap.put(testClassName, methodRunHistoryMap);
        }
        return methodRunHistoryMap;
    }

    private OutputStream getOutputStream(WrappedReportEntry testSetReportEntry) {
        File reportFile = StatelessXmlReporter.getReportFile(testSetReportEntry, this.reportsDirectory, this.reportNameSuffix);
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        try {
            return new BufferedOutputStream(new FileOutputStream(reportFile), 16384);
        }
        catch (Exception e) {
            throw new ReporterException("When writing report", e);
        }
    }

    private static OutputStreamWriter getWriter(OutputStream fos) {
        return new OutputStreamWriter(fos, StringUtils.UTF_8);
    }

    private static void getAddMethodEntryList(Map<String, List<WrappedReportEntry>> methodRunHistoryMap, WrappedReportEntry methodEntry) {
        List<WrappedReportEntry> methodEntryList = methodRunHistoryMap.get(methodEntry.getName());
        if (methodEntryList == null) {
            methodEntryList = new ArrayList<WrappedReportEntry>();
            methodRunHistoryMap.put(methodEntry.getName(), methodEntryList);
        }
        methodEntryList.add(methodEntry);
    }

    private static File getReportFile(ReportEntry report, File reportsDirectory, String reportNameSuffix) {
        String reportName = "TEST-" + report.getName();
        String customizedReportName = StringUtils.isBlank(reportNameSuffix) ? reportName : reportName + "-" + reportNameSuffix;
        return new File(reportsDirectory, FileReporterUtils.stripIllegalFilenameChars(customizedReportName + ".xml"));
    }

    private static void startTestElement(XMLWriter ppw, WrappedReportEntry report, String reportNameSuffix, String timeAsString) {
        ppw.startElement("testcase");
        ppw.addAttribute("name", report.getReportName());
        if (report.getGroup() != null) {
            ppw.addAttribute("group", report.getGroup());
        }
        if (report.getSourceName() != null) {
            if (reportNameSuffix != null && !reportNameSuffix.isEmpty()) {
                ppw.addAttribute("classname", report.getSourceName() + "(" + reportNameSuffix + ")");
            } else {
                ppw.addAttribute("classname", report.getSourceName());
            }
        }
        ppw.addAttribute("time", timeAsString);
    }

    private void createTestSuiteElement(XMLWriter ppw, WrappedReportEntry report, TestSetStats testSetStats, String timeAsString) {
        ppw.startElement("testsuite");
        ppw.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        ppw.addAttribute("xsi:noNamespaceSchemaLocation", this.xsdSchemaLocation);
        ppw.addAttribute("name", report.getReportName(this.reportNameSuffix));
        if (report.getGroup() != null) {
            ppw.addAttribute("group", report.getGroup());
        }
        ppw.addAttribute("time", timeAsString);
        ppw.addAttribute("tests", String.valueOf(testSetStats.getCompletedCount()));
        ppw.addAttribute("errors", String.valueOf(testSetStats.getErrors()));
        ppw.addAttribute("skipped", String.valueOf(testSetStats.getSkipped()));
        ppw.addAttribute("failures", String.valueOf(testSetStats.getFailures()));
    }

    private static void getTestProblems(OutputStreamWriter outputStreamWriter, XMLWriter ppw, WrappedReportEntry report, boolean trimStackTrace, OutputStream fw, String testErrorType, boolean createOutErrElementsInside) {
        SafeThrowable t;
        ppw.startElement(testErrorType);
        String stackTrace = report.getStackTrace(trimStackTrace);
        if (report.getMessage() != null && !report.getMessage().isEmpty()) {
            ppw.addAttribute("message", StatelessXmlReporter.extraEscape(report.getMessage(), true));
        }
        if (report.getStackTraceWriter() != null && (t = report.getStackTraceWriter().getThrowable()) != null) {
            if (t.getMessage() != null) {
                ppw.addAttribute("type", stackTrace.contains(":") ? stackTrace.substring(0, stackTrace.indexOf(":")) : stackTrace);
            } else {
                ppw.addAttribute("type", new StringTokenizer(stackTrace).nextToken());
            }
        }
        if (stackTrace != null) {
            ppw.writeText(StatelessXmlReporter.extraEscape(stackTrace, false));
        }
        if (createOutErrElementsInside) {
            StatelessXmlReporter.createOutErrElements(outputStreamWriter, ppw, report, fw);
        }
        ppw.endElement();
    }

    private static void createOutErrElements(OutputStreamWriter outputStreamWriter, XMLWriter ppw, WrappedReportEntry report, OutputStream fw) {
        EncodingOutputStream eos = new EncodingOutputStream(fw);
        StatelessXmlReporter.addOutputStreamElement(outputStreamWriter, eos, ppw, report.getStdout(), "system-out");
        StatelessXmlReporter.addOutputStreamElement(outputStreamWriter, eos, ppw, report.getStdErr(), "system-err");
    }

    private static void addOutputStreamElement(OutputStreamWriter outputStreamWriter, EncodingOutputStream eos, XMLWriter xmlWriter, Utf8RecodingDeferredFileOutputStream utf8RecodingDeferredFileOutputStream, String name) {
        if (utf8RecodingDeferredFileOutputStream != null && utf8RecodingDeferredFileOutputStream.getByteCount() > 0L) {
            xmlWriter.startElement(name);
            try {
                xmlWriter.writeText("");
                outputStreamWriter.flush();
                utf8RecodingDeferredFileOutputStream.close();
                eos.getUnderlying().write(ByteConstantsHolder.CDATA_START_BYTES);
                utf8RecodingDeferredFileOutputStream.writeTo(eos);
                eos.getUnderlying().write(ByteConstantsHolder.CDATA_END_BYTES);
                eos.flush();
            }
            catch (IOException e) {
                throw new ReporterException("When writing xml report stdout/stderr", e);
            }
            xmlWriter.endElement();
        }
    }

    private static void showProperties(XMLWriter xmlWriter, Map<String, String> systemProperties) {
        xmlWriter.startElement("properties");
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = "null";
            }
            xmlWriter.startElement("property");
            xmlWriter.addAttribute("name", key);
            xmlWriter.addAttribute("value", StatelessXmlReporter.extraEscape(value, true));
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private static String extraEscape(String message, boolean attribute) {
        return StatelessXmlReporter.containsEscapesIllegalXml10(message) ? StatelessXmlReporter.escapeXml(message, attribute) : message;
    }

    private static boolean containsEscapesIllegalXml10(String message) {
        int size = message.length();
        for (int i = 0; i < size; ++i) {
            if (!StatelessXmlReporter.isIllegalEscape(message.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isIllegalEscape(char c) {
        return StatelessXmlReporter.isIllegalEscape((int)c);
    }

    private static boolean isIllegalEscape(int c) {
        return c >= 0 && c < 32 && c != 10 && c != 13 && c != 9;
    }

    private static String escapeXml(String text, boolean attribute) {
        StringBuilder sb = new StringBuilder(text.length() * 2);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (StatelessXmlReporter.isIllegalEscape(c)) {
                sb.append(attribute ? "&#" : "&amp#").append((int)c).append(';');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final class ByteConstantsHolder {
        private static final byte[] CDATA_START_BYTES = "<![CDATA[".getBytes(StringUtils.UTF_8);
        private static final byte[] CDATA_END_BYTES = "]]>".getBytes(StringUtils.UTF_8);
        private static final byte[] CDATA_ESCAPE_STRING_BYTES = "]]><![CDATA[>".getBytes(StringUtils.UTF_8);
        private static final byte[] AMP_BYTES = "&amp#".getBytes(StringUtils.UTF_8);

        private ByteConstantsHolder() {
        }
    }

    private static final class EncodingOutputStream
    extends FilterOutputStream {
        private int c1;
        private int c2;

        public EncodingOutputStream(OutputStream out) {
            super(out);
        }

        public OutputStream getUnderlying() {
            return this.out;
        }

        private boolean isCdataEndBlock(int c) {
            return this.c1 == 93 && this.c2 == 93 && c == 62;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.isCdataEndBlock(b)) {
                this.out.write(ByteConstantsHolder.CDATA_ESCAPE_STRING_BYTES);
            } else if (StatelessXmlReporter.isIllegalEscape(b)) {
                this.out.write(ByteConstantsHolder.AMP_BYTES);
                this.out.write(String.valueOf(b).getBytes(StringUtils.UTF_8));
                this.out.write(59);
            } else {
                this.out.write(b);
            }
            this.c1 = this.c2;
            this.c2 = b;
        }
    }
}

