/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.plugin.surefire.booterclient.output.MultipleFailureException;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;

public final class ThreadedStreamConsumer
implements StreamConsumer,
Closeable {
    private static final String END_ITEM = "";
    private static final int ITEM_LIMIT_BEFORE_SLEEP = 10000;
    private final BlockingQueue<String> items = new ArrayBlockingQueue<String>(10000);
    private final AtomicBoolean stop = new AtomicBoolean();
    private final Thread thread;
    private final Pumper pumper;

    public ThreadedStreamConsumer(StreamConsumer target) {
        this.pumper = new Pumper(target);
        this.thread = DaemonThreadFactory.newDaemonThread(this.pumper, "ThreadedStreamConsumer");
        this.thread.start();
    }

    @Override
    public void consumeLine(String s) {
        if (this.stop.get() && !this.thread.isAlive()) {
            this.items.clear();
            return;
        }
        try {
            this.items.put(s);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.stop.compareAndSet(false, true)) {
            this.items.clear();
            try {
                this.items.put(END_ITEM);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.pumper.hasErrors()) {
            this.pumper.throwErrors();
        }
    }

    private boolean shouldStopQueueing(String item) {
        return item == END_ITEM;
    }

    final class Pumper
    implements Runnable {
        private final StreamConsumer target;
        private final MultipleFailureException errors = new MultipleFailureException();

        Pumper(StreamConsumer target) {
            this.target = target;
        }

        @Override
        public void run() {
            while (!ThreadedStreamConsumer.this.stop.get()) {
                try {
                    String item = (String)ThreadedStreamConsumer.this.items.take();
                    if (ThreadedStreamConsumer.this.shouldStopQueueing(item)) {
                        return;
                    }
                    this.target.consumeLine(item);
                }
                catch (Throwable t) {
                    this.errors.addException(t);
                }
            }
        }

        boolean hasErrors() {
            return this.errors.hasNestedExceptions();
        }

        void throwErrors() throws IOException {
            throw this.errors;
        }
    }
}

