/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.File;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.util.internal.DumpFileUtils;

public final class InPluginProcessDumpSingleton {
    private static final InPluginProcessDumpSingleton SINGLETON = new InPluginProcessDumpSingleton();
    private final String creationDate = DumpFileUtils.newFormattedDateFileName();

    private InPluginProcessDumpSingleton() {
    }

    public static InPluginProcessDumpSingleton getSingleton() {
        return SINGLETON;
    }

    public synchronized File dumpException(Throwable t, String msg, DefaultReporterFactory defaultReporterFactory, int jvmRun) {
        File dump = InPluginProcessDumpSingleton.newDumpFile(defaultReporterFactory, jvmRun);
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, dump);
        return dump;
    }

    public synchronized void dumpException(Throwable t, String msg, DefaultReporterFactory defaultReporterFactory) {
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, this.newDumpFile(defaultReporterFactory));
    }

    public synchronized void dumpException(Throwable t, DefaultReporterFactory defaultReporterFactory) {
        DumpFileUtils.dumpException(t, this.newDumpFile(defaultReporterFactory));
    }

    public synchronized File dumpText(String msg, DefaultReporterFactory defaultReporterFactory, int jvmRun) {
        File dump = InPluginProcessDumpSingleton.newDumpFile(defaultReporterFactory, jvmRun);
        DumpFileUtils.dumpText(msg == null ? "null" : msg, dump);
        return dump;
    }

    public synchronized void dumpText(String msg, DefaultReporterFactory defaultReporterFactory) {
        DumpFileUtils.dumpText(msg == null ? "null" : msg, this.newDumpFile(defaultReporterFactory));
    }

    private File newDumpFile(DefaultReporterFactory defaultReporterFactory) {
        File reportsDirectory = defaultReporterFactory.getReportsDirectory();
        return new File(reportsDirectory, this.creationDate + ".dumpstream");
    }

    private static File newDumpFile(DefaultReporterFactory defaultReporterFactory, int jvmRun) {
        File reportsDirectory = defaultReporterFactory.getReportsDirectory();
        return new File(reportsDirectory, String.format(SurefireHelper.DUMPSTREAM_FILENAME_FORMATTER, jvmRun));
    }
}

