/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.lazytestprovider;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.AbstractCommandStream;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.NotifiableTestStream;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.Shutdown;

public final class TestLessInputStream
extends AbstractCommandStream {
    private final Semaphore barrier = new Semaphore(0);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Queue<Command> immediateCommands = new ConcurrentLinkedQueue<Command>();
    private final TestLessInputStreamBuilder builder;
    private Iterator<Command> cachableCommands;

    private TestLessInputStream(TestLessInputStreamBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void provideNewTest() {
    }

    @Override
    public void skipSinceNextTest() {
        if (this.canContinue()) {
            this.immediateCommands.add(Command.SKIP_SINCE_NEXT_TEST);
            this.barrier.release();
        }
    }

    @Override
    public void shutdown(Shutdown shutdownType) {
        if (this.canContinue()) {
            this.immediateCommands.add(Command.toShutdown(shutdownType));
            this.barrier.release();
        }
    }

    @Override
    public void noop() {
        if (this.canContinue()) {
            this.immediateCommands.add(Command.NOOP);
            this.barrier.release();
        }
    }

    @Override
    public void acknowledgeByeEventReceived() {
        if (this.canContinue()) {
            this.immediateCommands.add(Command.BYE_ACK);
            this.barrier.release();
        }
    }

    @Override
    protected boolean isClosed() {
        return this.closed.get();
    }

    @Override
    protected Command nextCommand() {
        Command cmd = this.immediateCommands.poll();
        if (cmd == null) {
            if (this.cachableCommands == null) {
                this.cachableCommands = this.builder.getIterableCachable().iterator();
            }
            cmd = this.cachableCommands.next();
        }
        return cmd;
    }

    @Override
    protected void beforeNextCommand() throws IOException {
        this.awaitNextCommand();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.invalidateInternalBuffer();
            this.barrier.drainPermits();
            this.barrier.release();
        }
    }

    int availablePermits() {
        return this.barrier.availablePermits();
    }

    private void awaitNextCommand() throws IOException {
        try {
            this.barrier.acquire();
        }
        catch (InterruptedException e) {
            this.invalidateInternalBuffer();
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static final class TestLessInputStreamBuilder {
        private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Queue<TestLessInputStream> aliveStreams = new ConcurrentLinkedQueue<TestLessInputStream>();
        private final ImmediateCommands immediateCommands = new ImmediateCommands();
        private final CachableCommands cachableCommands = new CachableCommands();
        private final Node head = new Node(null);
        private final Iterable<Command> iterableCachable = new Iterable<Command>(){

            @Override
            public Iterator<Command> iterator() {
                return new CIt();
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TestLessInputStream build() {
            ReentrantReadWriteLock.WriteLock lock = this.rwLock.writeLock();
            lock.lock();
            try {
                TestLessInputStream is = new TestLessInputStream(this);
                this.aliveStreams.offer(is);
                TestLessInputStream testLessInputStream = is;
                return testLessInputStream;
            }
            finally {
                lock.unlock();
            }
        }

        public void removeStream(TestLessInputStream is) {
            ReentrantReadWriteLock.WriteLock lock = this.rwLock.writeLock();
            lock.lock();
            try {
                this.aliveStreams.remove(is);
            }
            finally {
                lock.unlock();
            }
        }

        public NotifiableTestStream getImmediateCommands() {
            return this.immediateCommands;
        }

        public NotifiableTestStream getCachableCommands() {
            return this.cachableCommands;
        }

        Iterable<Command> getIterableCachable() {
            return this.iterableCachable;
        }

        private boolean addTailNodeIfAbsent(Command command) {
            Node newTail = new Node(command);
            Node currentTail = this.head;
            while (true) {
                Node successor;
                if ((successor = (Node)currentTail.next.get()) != null) {
                    currentTail = successor;
                    if (!command.equals(currentTail.command)) continue;
                    return false;
                }
                if (currentTail.next.compareAndSet(null, newTail)) break;
            }
            return true;
        }

        private static Node nextCachedNode(Node current) {
            return (Node)current.next.get();
        }

        private static class Node {
            private final AtomicReference<Node> next = new AtomicReference();
            private final Command command;

            Node(Command command) {
                this.command = command;
            }
        }

        private final class CachableCommands
        implements NotifiableTestStream {
            private CachableCommands() {
            }

            @Override
            public void provideNewTest() {
            }

            @Override
            public void skipSinceNextTest() {
                ReentrantReadWriteLock.ReadLock lock = TestLessInputStreamBuilder.this.rwLock.readLock();
                lock.lock();
                try {
                    if (TestLessInputStreamBuilder.this.addTailNodeIfAbsent(Command.SKIP_SINCE_NEXT_TEST)) {
                        this.release();
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public void shutdown(Shutdown shutdownType) {
                ReentrantReadWriteLock.ReadLock lock = TestLessInputStreamBuilder.this.rwLock.readLock();
                lock.lock();
                try {
                    if (TestLessInputStreamBuilder.this.addTailNodeIfAbsent(Command.toShutdown(shutdownType))) {
                        this.release();
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public void noop() {
                ReentrantReadWriteLock.ReadLock lock = TestLessInputStreamBuilder.this.rwLock.readLock();
                lock.lock();
                try {
                    if (TestLessInputStreamBuilder.this.addTailNodeIfAbsent(Command.NOOP)) {
                        this.release();
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public void acknowledgeByeEventReceived() {
                ReentrantReadWriteLock.ReadLock lock = TestLessInputStreamBuilder.this.rwLock.readLock();
                lock.lock();
                try {
                    if (TestLessInputStreamBuilder.this.addTailNodeIfAbsent(Command.BYE_ACK)) {
                        this.release();
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            private void release() {
                for (TestLessInputStream aliveStream : TestLessInputStreamBuilder.this.aliveStreams) {
                    aliveStream.barrier.release();
                }
            }
        }

        private final class ImmediateCommands
        implements NotifiableTestStream {
            private ImmediateCommands() {
            }

            @Override
            public void provideNewTest() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void skipSinceNextTest() {
                ReentrantReadWriteLock.ReadLock lock = TestLessInputStreamBuilder.this.rwLock.readLock();
                lock.lock();
                try {
                    for (TestLessInputStream aliveStream : TestLessInputStreamBuilder.this.aliveStreams) {
                        aliveStream.skipSinceNextTest();
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shutdown(Shutdown shutdownType) {
                ReentrantReadWriteLock.ReadLock lock = TestLessInputStreamBuilder.this.rwLock.readLock();
                lock.lock();
                try {
                    for (TestLessInputStream aliveStream : TestLessInputStreamBuilder.this.aliveStreams) {
                        aliveStream.shutdown(shutdownType);
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noop() {
                ReentrantReadWriteLock.ReadLock lock = TestLessInputStreamBuilder.this.rwLock.readLock();
                lock.lock();
                try {
                    for (TestLessInputStream aliveStream : TestLessInputStreamBuilder.this.aliveStreams) {
                        aliveStream.noop();
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acknowledgeByeEventReceived() {
                ReentrantReadWriteLock.ReadLock lock = TestLessInputStreamBuilder.this.rwLock.readLock();
                lock.lock();
                try {
                    for (TestLessInputStream aliveStream : TestLessInputStreamBuilder.this.aliveStreams) {
                        aliveStream.acknowledgeByeEventReceived();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }

        private final class CIt
        implements Iterator<Command> {
            private Node node;

            private CIt() {
                this.node = TestLessInputStreamBuilder.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.examineNext(false) != null;
            }

            @Override
            public Command next() {
                Command command = this.examineNext(true);
                if (command == null) {
                    throw new NoSuchElementException();
                }
                return command;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private Command examineNext(boolean store) {
                Node next = TestLessInputStreamBuilder.nextCachedNode(this.node);
                if (store && next != null) {
                    this.node = next;
                }
                return next == null ? null : next.command;
            }
        }
    }
}

