/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.KeyValueSource;
import org.apache.maven.surefire.util.internal.StringUtils;

public class SurefireProperties
extends Properties
implements KeyValueSource {
    private static final Collection<String> KEYS_THAT_CANNOT_BE_USED_AS_SYSTEM_PROPERTIES = Arrays.asList("java.library.path", "file.encoding", "jdk.map.althashing.threshold", "line.separator");
    private final LinkedHashSet<Object> items = new LinkedHashSet();

    public SurefireProperties() {
    }

    public SurefireProperties(Properties source) {
        if (source != null) {
            this.putAll((Map<?, ?>)source);
        }
    }

    public SurefireProperties(KeyValueSource source) {
        if (source != null) {
            source.copyTo(this);
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.items.add(key);
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.items.remove(key);
        return super.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.items.clear();
        super.clear();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.items);
    }

    public void copyPropertiesFrom(Properties source) {
        if (source != null) {
            this.putAll((Map<?, ?>)source);
        }
    }

    public Iterable<Object> getStringKeySet() {
        return this.keySet();
    }

    public Set<Object> propertiesThatCannotBeSetASystemProperties() {
        HashSet<Object> result = new HashSet<Object>();
        for (Object key : this.getStringKeySet()) {
            if (!KEYS_THAT_CANNOT_BE_USED_AS_SYSTEM_PROPERTIES.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    public void copyToSystemProperties() {
        for (Object e : this.items) {
            String key = (String)e;
            String value = this.getProperty(key);
            System.setProperty(key, value);
        }
    }

    static SurefireProperties calculateEffectiveProperties(Properties systemProperties, Map<String, String> systemPropertyVariables, Properties userProperties, SurefireProperties props) {
        SurefireProperties result = new SurefireProperties();
        result.copyPropertiesFrom(systemProperties);
        result.copyPropertiesFrom(props);
        SurefireProperties.copyProperties(result, systemPropertyVariables);
        result.copyPropertiesFrom(userProperties);
        return result;
    }

    public static void copyProperties(Properties target, Map<String, String> source) {
        if (source != null) {
            Iterator<String> iterator = source.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String value = source.get(key = iterator.next());
                target.setProperty(key, value == null ? "" : value);
            }
        }
    }

    @Override
    public void copyTo(Map<Object, Object> target) {
        target.putAll(this);
    }

    public void setProperty(String key, File file) {
        if (file != null) {
            this.setProperty(key, file.toString());
        }
    }

    public void setProperty(String key, Boolean aBoolean) {
        if (aBoolean != null) {
            this.setProperty(key, aBoolean.toString());
        }
    }

    public void setProperty(String key, Long value) {
        if (value != null) {
            this.setProperty(key, value.toString());
        }
    }

    public void addList(List<?> items, String propertyPrefix) {
        if (items != null && !items.isEmpty()) {
            int i = 0;
            for (Object item : items) {
                String[] stringArray;
                if (item == null) {
                    throw new NullPointerException(propertyPrefix + i + " has null value");
                }
                for (String aStringArray : stringArray = StringUtils.split(item.toString(), ",")) {
                    this.setProperty(propertyPrefix + i, aStringArray);
                    ++i;
                }
            }
        }
    }

    public void setClasspath(String prefix, Classpath classpath) {
        List<String> classpathElements = classpath.getClassPath();
        for (int i = 0; i < classpathElements.size(); ++i) {
            String element = classpathElements.get(i);
            this.setProperty(prefix + i, element);
        }
    }

    private static SurefireProperties loadProperties(InputStream inStream) throws IOException {
        try {
            Properties p = new Properties();
            p.load(inStream);
            SurefireProperties surefireProperties = new SurefireProperties(p);
            return surefireProperties;
        }
        finally {
            SurefireProperties.close(inStream);
        }
    }

    public static SurefireProperties loadProperties(File file) throws IOException {
        return file == null ? new SurefireProperties() : SurefireProperties.loadProperties(new FileInputStream(file));
    }

    private static void close(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setNullableProperty(String key, String value) {
        if (value != null) {
            super.setProperty(key, value);
        }
    }
}

