/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugin.surefire.log.PluginConsoleLogger;
import org.apache.maven.surefire.cli.CommandLineOption;
import org.apache.maven.surefire.shade.org.apache.commons.lang3.SystemUtils;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.internal.DumpFileUtils;

public final class SurefireHelper {
    private static final String DUMP_FILE_DATE = DumpFileUtils.newFormattedDateFileName();
    public static final String DUMP_FILE_PREFIX = DUMP_FILE_DATE + "-jvmRun";
    public static final String DUMPSTREAM_FILENAME_FORMATTER = DUMP_FILE_PREFIX + "%d" + ".dumpstream";
    private static final int MAX_PATH_LENGTH_WINDOWS = 247;
    private static final String[] DUMP_FILES_PRINT = new String[]{"[date]-jvmRun[N].dump", "[date].dumpstream", "[date]-jvmRun[N].dumpstream"};

    private SurefireHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static String[] getDumpFilesToPrint() {
        return (String[])DUMP_FILES_PRINT.clone();
    }

    public static void reportExecution(SurefireReportParameters reportParameters, RunResult result, PluginConsoleLogger log, Exception firstForkException) throws MojoFailureException, MojoExecutionException {
        if (firstForkException == null && !result.isTimeout() && result.isErrorFree()) {
            if (result.getCompletedCount() == 0 && SurefireHelper.failIfNoTests(reportParameters)) {
                throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
            }
            return;
        }
        if (reportParameters.isTestFailureIgnore()) {
            log.error(SurefireHelper.createErrorMessage(reportParameters, result, firstForkException));
        } else {
            SurefireHelper.throwException(reportParameters, result, firstForkException);
        }
    }

    public static List<CommandLineOption> commandLineOptions(MavenSession session, PluginConsoleLogger log) {
        ArrayList<CommandLineOption> cli = new ArrayList<CommandLineOption>();
        if (log.isErrorEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_ERROR);
        }
        if (log.isWarnEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_WARN);
        }
        if (log.isInfoEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_INFO);
        }
        if (log.isDebugEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_DEBUG);
        }
        try {
            String f;
            Method getRequestMethod = session.getClass().getMethod("getRequest", new Class[0]);
            MavenExecutionRequest request = (MavenExecutionRequest)getRequestMethod.invoke((Object)session, new Object[0]);
            if (request.isShowErrors()) {
                cli.add(CommandLineOption.SHOW_ERRORS);
            }
            if ((f = SurefireHelper.getFailureBehavior(request)) != null) {
                cli.add(CommandLineOption.valueOf(f.startsWith("REACTOR_") ? f : "REACTOR_" + f));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.unmodifiableList(cli);
    }

    public static void logDebugOrCliShowErrors(String s, PluginConsoleLogger log, Collection<CommandLineOption> cli) {
        if (cli.contains((Object)CommandLineOption.LOGGING_LEVEL_DEBUG)) {
            log.debug(s);
        } else if (cli.contains((Object)CommandLineOption.SHOW_ERRORS)) {
            if (log.isDebugEnabled()) {
                log.debug(s);
            } else {
                log.info(s);
            }
        }
    }

    public static String escapeToPlatformPath(String path) {
        if (SystemUtils.IS_OS_WINDOWS && path.length() > 247) {
            path = path.startsWith("\\\\") ? "\\\\?\\UNC\\" + path.substring(2) : "\\\\?\\" + path;
        }
        return path;
    }

    private static String getFailureBehavior(MavenExecutionRequest request) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        try {
            return request.getFailureBehavior();
        }
        catch (NoSuchMethodError e) {
            return (String)request.getClass().getMethod("getReactorFailureBehavior", new Class[0]).invoke((Object)request, new Object[0]);
        }
    }

    private static boolean failIfNoTests(SurefireReportParameters reportParameters) {
        return reportParameters.getFailIfNoTests() != null && reportParameters.getFailIfNoTests() != false;
    }

    private static boolean isFatal(Exception firstForkException) {
        return firstForkException != null && !(firstForkException instanceof TestSetFailedException);
    }

    private static void throwException(SurefireReportParameters reportParameters, RunResult result, Exception firstForkException) throws MojoFailureException, MojoExecutionException {
        if (SurefireHelper.isFatal(firstForkException) || result.isInternalError()) {
            throw new MojoExecutionException(SurefireHelper.createErrorMessage(reportParameters, result, firstForkException), firstForkException);
        }
        throw new MojoFailureException(SurefireHelper.createErrorMessage(reportParameters, result, firstForkException), firstForkException);
    }

    private static String createErrorMessage(SurefireReportParameters reportParameters, RunResult result, Exception firstForkException) {
        StringBuilder msg = new StringBuilder(512);
        if (result.isTimeout()) {
            msg.append("There was a timeout or other error in the fork");
        } else {
            msg.append("There are test failures.\n\nPlease refer to ").append(reportParameters.getReportsDirectory()).append(" for the individual test results.").append('\n').append("Please refer to dump files (if any exist) ").append(DUMP_FILES_PRINT[0]).append(", ").append(DUMP_FILES_PRINT[1]).append(" and ").append(DUMP_FILES_PRINT[2]).append(".");
        }
        if (firstForkException != null && firstForkException.getLocalizedMessage() != null) {
            msg.append('\n').append(firstForkException.getLocalizedMessage());
        }
        if (result.isFailure()) {
            msg.append('\n').append(result.getFailure());
        }
        return msg.toString();
    }
}

