/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.booter.SurefireReflector;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.SurefireReflectionException;

public class CommonReflector {
    private final Class<?> startupReportConfiguration;
    private final Class<?> consoleLogger;
    private final ClassLoader surefireClassLoader;

    public CommonReflector(@Nonnull ClassLoader surefireClassLoader) {
        this.surefireClassLoader = surefireClassLoader;
        try {
            this.startupReportConfiguration = surefireClassLoader.loadClass(StartupReportConfiguration.class.getName());
            this.consoleLogger = surefireClassLoader.loadClass(ConsoleLogger.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public Object createReportingReporterFactory(@Nonnull StartupReportConfiguration startupReportConfiguration, @Nonnull ConsoleLogger consoleLogger) {
        Class[] args = new Class[]{this.startupReportConfiguration, this.consoleLogger};
        Object src = this.createStartupReportConfiguration(startupReportConfiguration);
        Object logger = SurefireReflector.createConsoleLogger(consoleLogger, this.surefireClassLoader);
        Object[] params = new Object[]{src, logger};
        return ReflectionUtils.instantiateObject(DefaultReporterFactory.class.getName(), args, params, this.surefireClassLoader);
    }

    private Object createStartupReportConfiguration(@Nonnull StartupReportConfiguration reporterConfiguration) {
        Constructor constructor = ReflectionUtils.getConstructor(this.startupReportConfiguration, Boolean.TYPE, Boolean.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, File.class, Boolean.TYPE, String.class, File.class, Boolean.TYPE, Integer.TYPE, String.class);
        Object[] params = new Object[]{reporterConfiguration.isUseFile(), reporterConfiguration.isPrintSummary(), reporterConfiguration.getReportFormat(), reporterConfiguration.isRedirectTestOutputToFile(), reporterConfiguration.isDisableXmlReport(), reporterConfiguration.getReportsDirectory(), reporterConfiguration.isTrimStackTrace(), reporterConfiguration.getReportNameSuffix(), reporterConfiguration.getStatisticsFile(), reporterConfiguration.isRequiresRunHistory(), reporterConfiguration.getRerunFailingTestsCount(), reporterConfiguration.getXsdSchemaLocation()};
        return ReflectionUtils.newInstance(constructor, params);
    }
}

