/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.org.apache.http.impl.io;

import io.rivulet.org.apache.http.ConnectionClosedException;
import io.rivulet.org.apache.http.HttpException;
import io.rivulet.org.apache.http.HttpRequest;
import io.rivulet.org.apache.http.HttpRequestFactory;
import io.rivulet.org.apache.http.ParseException;
import io.rivulet.org.apache.http.RequestLine;
import io.rivulet.org.apache.http.config.MessageConstraints;
import io.rivulet.org.apache.http.impl.DefaultHttpRequestFactory;
import io.rivulet.org.apache.http.impl.io.AbstractMessageParser;
import io.rivulet.org.apache.http.io.SessionInputBuffer;
import io.rivulet.org.apache.http.message.LineParser;
import io.rivulet.org.apache.http.message.ParserCursor;
import io.rivulet.org.apache.http.params.HttpParams;
import io.rivulet.org.apache.http.util.Args;
import io.rivulet.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpRequest parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        RequestLine requestline = this.lineParser.parseRequestLine(this.lineBuf, cursor);
        return this.requestFactory.newHttpRequest(requestline);
    }
}

