/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.org.apache.http.impl.conn;

import io.rivulet.org.apache.http.HttpHost;
import io.rivulet.org.apache.http.annotation.Contract;
import io.rivulet.org.apache.http.annotation.ThreadingBehavior;
import io.rivulet.org.apache.http.conn.SchemePortResolver;
import io.rivulet.org.apache.http.conn.UnsupportedSchemeException;
import io.rivulet.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) throws UnsupportedSchemeException {
        Args.notNull(host, "HTTP host");
        int port = host.getPort();
        if (port > 0) {
            return port;
        }
        String name = host.getSchemeName();
        if (name.equalsIgnoreCase("http")) {
            return 80;
        }
        if (name.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(name + " protocol is not supported");
    }
}

