/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.org.antlr.v4.runtime.misc;

import io.rivulet.org.antlr.v4.runtime.misc.IntSet;
import io.rivulet.org.antlr.v4.runtime.misc.IntegerList;
import io.rivulet.org.antlr.v4.runtime.misc.Interval;
import io.rivulet.org.antlr.v4.runtime.misc.NotNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class IntervalSet
implements IntSet {
    public static final IntervalSet COMPLETE_CHAR_SET = IntervalSet.of(0, 65534);
    public static final IntervalSet EMPTY_SET = new IntervalSet(new int[0]);
    protected List<Interval> intervals;
    protected boolean readonly;

    public IntervalSet(List<Interval> intervals) {
        this.intervals = intervals;
    }

    public IntervalSet(IntervalSet set) {
        this(new int[0]);
        this.addAll(set);
    }

    public IntervalSet(int ... els) {
        if (els == null) {
            this.intervals = new ArrayList<Interval>(2);
        } else {
            this.intervals = new ArrayList<Interval>(els.length);
            for (int e : els) {
                this.add(e);
            }
        }
    }

    @NotNull
    public static IntervalSet of(int a) {
        IntervalSet s = new IntervalSet(new int[0]);
        s.add(a);
        return s;
    }

    public static IntervalSet of(int a, int b) {
        IntervalSet s = new IntervalSet(new int[0]);
        s.add(a, b);
        return s;
    }

    public void clear() {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.intervals.clear();
    }

    @Override
    public void add(int el) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.add(el, el);
    }

    public void add(int a, int b) {
        this.add(Interval.of(a, b));
    }

    protected void add(Interval addition) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        if (addition.b < addition.a) {
            return;
        }
        ListIterator<Interval> iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval r = iter.next();
            if (addition.equals(r)) {
                return;
            }
            if (addition.adjacent(r) || !addition.disjoint(r)) {
                Interval next;
                Interval bigger = addition.union(r);
                iter.set(bigger);
                if (iter.hasNext() && (bigger.adjacent(next = iter.next()) || !bigger.disjoint(next))) {
                    iter.remove();
                    iter.previous();
                    iter.set(bigger.union(next));
                }
                return;
            }
            if (!addition.startsBeforeDisjoint(r)) continue;
            iter.previous();
            iter.add(addition);
            return;
        }
        this.intervals.add(addition);
    }

    public static IntervalSet or(IntervalSet[] sets) {
        IntervalSet r = new IntervalSet(new int[0]);
        for (IntervalSet s : sets) {
            r.addAll(s);
        }
        return r;
    }

    @Override
    public IntervalSet addAll(IntSet set) {
        if (set == null) {
            return this;
        }
        if (!(set instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't add non IntSet (" + set.getClass().getName() + ") to IntervalSet");
        }
        IntervalSet other = (IntervalSet)set;
        int n = other.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = other.intervals.get(i);
            this.add(I.a, I.b);
        }
        return this;
    }

    public IntervalSet complement(int minElement, int maxElement) {
        return this.complement(IntervalSet.of(minElement, maxElement));
    }

    @Override
    public IntervalSet complement(IntSet vocabulary) {
        if (vocabulary == null) {
            return null;
        }
        if (!(vocabulary instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't complement with non IntervalSet (" + vocabulary.getClass().getName() + ")");
        }
        IntervalSet vocabularyIS = (IntervalSet)vocabulary;
        int maxElement = vocabularyIS.getMaxElement();
        IntervalSet compl = new IntervalSet(new int[0]);
        int n = this.intervals.size();
        if (n == 0) {
            return compl;
        }
        Interval first = this.intervals.get(0);
        if (first.a > 0) {
            IntervalSet s = IntervalSet.of(0, first.a - 1);
            IntervalSet a = s.and(vocabularyIS);
            compl.addAll(a);
        }
        for (int i = 1; i < n; ++i) {
            Interval previous = this.intervals.get(i - 1);
            Interval current = this.intervals.get(i);
            IntervalSet s = IntervalSet.of(previous.b + 1, current.a - 1);
            IntervalSet a = s.and(vocabularyIS);
            compl.addAll(a);
        }
        Interval last = this.intervals.get(n - 1);
        if (last.b < maxElement) {
            IntervalSet s = IntervalSet.of(last.b + 1, maxElement);
            IntervalSet a = s.and(vocabularyIS);
            compl.addAll(a);
        }
        return compl;
    }

    @Override
    public IntervalSet subtract(IntSet other) {
        return this.and(((IntervalSet)other).complement(COMPLETE_CHAR_SET));
    }

    @Override
    public IntervalSet or(IntSet a) {
        IntervalSet o = new IntervalSet(new int[0]);
        o.addAll(this);
        o.addAll(a);
        return o;
    }

    @Override
    public IntervalSet and(IntSet other) {
        if (other == null) {
            return null;
        }
        List<Interval> myIntervals = this.intervals;
        List<Interval> theirIntervals = ((IntervalSet)other).intervals;
        IntervalSet intersection = null;
        int mySize = myIntervals.size();
        int theirSize = theirIntervals.size();
        int i = 0;
        int j = 0;
        while (i < mySize && j < theirSize) {
            Interval theirs;
            Interval mine = myIntervals.get(i);
            if (mine.startsBeforeDisjoint(theirs = theirIntervals.get(j))) {
                ++i;
                continue;
            }
            if (theirs.startsBeforeDisjoint(mine)) {
                ++j;
                continue;
            }
            if (mine.properlyContains(theirs)) {
                if (intersection == null) {
                    intersection = new IntervalSet(new int[0]);
                }
                intersection.add(mine.intersection(theirs));
                ++j;
                continue;
            }
            if (theirs.properlyContains(mine)) {
                if (intersection == null) {
                    intersection = new IntervalSet(new int[0]);
                }
                intersection.add(mine.intersection(theirs));
                ++i;
                continue;
            }
            if (mine.disjoint(theirs)) continue;
            if (intersection == null) {
                intersection = new IntervalSet(new int[0]);
            }
            intersection.add(mine.intersection(theirs));
            if (mine.startsAfterNonDisjoint(theirs)) {
                ++j;
                continue;
            }
            if (!theirs.startsAfterNonDisjoint(mine)) continue;
            ++i;
        }
        if (intersection == null) {
            return new IntervalSet(new int[0]);
        }
        return intersection;
    }

    @Override
    public boolean contains(int el) {
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            if (el < a) break;
            if (el < a || el > b) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNil() {
        return this.intervals == null || this.intervals.isEmpty();
    }

    @Override
    public int getSingleElement() {
        if (this.intervals != null && this.intervals.size() == 1) {
            Interval I = this.intervals.get(0);
            if (I.a == I.b) {
                return I.a;
            }
        }
        return 0;
    }

    public int getMaxElement() {
        if (this.isNil()) {
            return 0;
        }
        Interval last = this.intervals.get(this.intervals.size() - 1);
        return last.b;
    }

    public int getMinElement() {
        if (this.isNil()) {
            return 0;
        }
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                if (v < 0) continue;
                return v;
            }
        }
        return 0;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public int hashCode() {
        if (this.isNil()) {
            return 0;
        }
        int n = 0;
        for (Interval I : this.intervals) {
            n += I.a;
        }
        return n;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IntervalSet)) {
            return false;
        }
        IntervalSet other = (IntervalSet)obj;
        return this.intervals.equals(other.intervals);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean elemAreChar) {
        StringBuilder buf = new StringBuilder();
        if (this.intervals == null || this.intervals.isEmpty()) {
            return "{}";
        }
        if (this.size() > 1) {
            buf.append("{");
        }
        Iterator<Interval> iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I = iter.next();
            int a = I.a;
            int b = I.b;
            if (a == b) {
                if (a == -1) {
                    buf.append("<EOF>");
                } else if (elemAreChar) {
                    buf.append("'").append((char)a).append("'");
                } else {
                    buf.append(a);
                }
            } else if (elemAreChar) {
                buf.append("'").append((char)a).append("'..'").append((char)b).append("'");
            } else {
                buf.append(a).append("..").append(b);
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (this.size() > 1) {
            buf.append("}");
        }
        return buf.toString();
    }

    public String toString(String[] tokenNames) {
        StringBuilder buf = new StringBuilder();
        if (this.intervals == null || this.intervals.isEmpty()) {
            return "{}";
        }
        if (this.size() > 1) {
            buf.append("{");
        }
        Iterator<Interval> iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I = iter.next();
            int a = I.a;
            int b = I.b;
            if (a == b) {
                buf.append(this.elementName(tokenNames, a));
            } else {
                for (int i = a; i <= b; ++i) {
                    if (i > a) {
                        buf.append(", ");
                    }
                    buf.append(this.elementName(tokenNames, i));
                }
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (this.size() > 1) {
            buf.append("}");
        }
        return buf.toString();
    }

    protected String elementName(String[] tokenNames, int a) {
        if (a == -1) {
            return "<EOF>";
        }
        if (a == -2) {
            return "<EPSILON>";
        }
        return tokenNames[a];
    }

    @Override
    public int size() {
        int n = 0;
        int numIntervals = this.intervals.size();
        if (numIntervals == 1) {
            Interval firstInterval = this.intervals.get(0);
            return firstInterval.b - firstInterval.a + 1;
        }
        for (int i = 0; i < numIntervals; ++i) {
            Interval I = this.intervals.get(i);
            n += I.b - I.a + 1;
        }
        return n;
    }

    public IntegerList toIntegerList() {
        IntegerList values = new IntegerList(this.size());
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                values.add(v);
            }
        }
        return values;
    }

    @Override
    public List<Integer> toList() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                values.add(v);
            }
        }
        return values;
    }

    public Set<Integer> toSet() {
        HashSet<Integer> s = new HashSet<Integer>();
        for (Interval I : this.intervals) {
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                s.add(v);
            }
        }
        return s;
    }

    public int get(int i) {
        int n = this.intervals.size();
        int index = 0;
        for (int j = 0; j < n; ++j) {
            Interval I = this.intervals.get(j);
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                if (index == i) {
                    return v;
                }
                ++index;
            }
        }
        return -1;
    }

    public int[] toArray() {
        return this.toIntegerList().toArray();
    }

    @Override
    public void remove(int el) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            if (el < a) break;
            if (el == a && el == b) {
                this.intervals.remove(i);
                break;
            }
            if (el == a) {
                ++I.a;
                break;
            }
            if (el == b) {
                --I.b;
                break;
            }
            if (el <= a || el >= b) continue;
            int oldb = I.b;
            I.b = el - 1;
            this.add(el + 1, oldb);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }
}

