/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.org.antlr.v4.runtime.atn;

import io.rivulet.org.antlr.v4.runtime.atn.PredictionContext;
import io.rivulet.org.antlr.v4.runtime.atn.SingletonPredictionContext;
import java.util.Arrays;
import java.util.Iterator;

public class ArrayPredictionContext
extends PredictionContext {
    public final PredictionContext[] parents;
    public final int[] returnStates;

    public ArrayPredictionContext(SingletonPredictionContext a) {
        this(new PredictionContext[]{a.parent}, new int[]{a.returnState});
    }

    public ArrayPredictionContext(PredictionContext[] parents, int[] returnStates) {
        super(ArrayPredictionContext.calculateHashCode(parents, returnStates));
        assert (parents != null && parents.length > 0);
        assert (returnStates != null && returnStates.length > 0);
        this.parents = parents;
        this.returnStates = returnStates;
    }

    protected static int calculateHashCode(PredictionContext[] parents, int[] returnStates) {
        return ArrayPredictionContext.calculateHashCode(ArrayPredictionContext.calculateParentHashCode(parents), ArrayPredictionContext.calculateReturnStatesHashCode(returnStates));
    }

    protected static int calculateParentHashCode(PredictionContext[] parents) {
        int hashCode = 1;
        for (PredictionContext p : parents) {
            if (p == null) continue;
            hashCode = hashCode * 31 ^ p.hashCode();
        }
        return hashCode;
    }

    protected static int calculateReturnStatesHashCode(int[] returnStates) {
        int hashCode = 1;
        for (int state : returnStates) {
            hashCode = hashCode * 31 ^ state;
        }
        return hashCode;
    }

    @Override
    public Iterator<SingletonPredictionContext> iterator() {
        return new Iterator<SingletonPredictionContext>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ArrayPredictionContext.this.parents.length;
            }

            @Override
            public SingletonPredictionContext next() {
                SingletonPredictionContext ctx = SingletonPredictionContext.create(ArrayPredictionContext.this.parents[this.i], ArrayPredictionContext.this.returnStates[this.i]);
                ++this.i;
                return ctx;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 1 && this.returnStates[0] == Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        return this.returnStates.length;
    }

    @Override
    public PredictionContext getParent(int index) {
        return this.parents[index];
    }

    @Override
    public int getReturnState(int index) {
        return this.returnStates[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayPredictionContext)) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        ArrayPredictionContext a = (ArrayPredictionContext)o;
        return Arrays.equals(this.returnStates, a.returnStates) && Arrays.equals(this.parents, a.parents);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this.returnStates.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if (this.returnStates[i] == Integer.MAX_VALUE) {
                buf.append("$");
                continue;
            }
            buf.append(this.returnStates[i]);
            if (this.parents[i] != null) {
                buf.append(' ');
                buf.append(this.parents[i].toString());
                continue;
            }
            buf.append("null");
        }
        buf.append("]");
        return buf.toString();
    }
}

