/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.org.antlr.v4.runtime.atn;

import io.rivulet.org.antlr.v4.runtime.atn.ATN;
import io.rivulet.org.antlr.v4.runtime.atn.ATNConfigSet;
import io.rivulet.org.antlr.v4.runtime.atn.ATNState;
import io.rivulet.org.antlr.v4.runtime.atn.ActionTransition;
import io.rivulet.org.antlr.v4.runtime.atn.AtomTransition;
import io.rivulet.org.antlr.v4.runtime.atn.BasicBlockStartState;
import io.rivulet.org.antlr.v4.runtime.atn.BasicState;
import io.rivulet.org.antlr.v4.runtime.atn.BlockEndState;
import io.rivulet.org.antlr.v4.runtime.atn.BlockStartState;
import io.rivulet.org.antlr.v4.runtime.atn.DecisionState;
import io.rivulet.org.antlr.v4.runtime.atn.EpsilonTransition;
import io.rivulet.org.antlr.v4.runtime.atn.LoopEndState;
import io.rivulet.org.antlr.v4.runtime.atn.NotSetTransition;
import io.rivulet.org.antlr.v4.runtime.atn.PlusBlockStartState;
import io.rivulet.org.antlr.v4.runtime.atn.PlusLoopbackState;
import io.rivulet.org.antlr.v4.runtime.atn.PredicateTransition;
import io.rivulet.org.antlr.v4.runtime.atn.PredictionContext;
import io.rivulet.org.antlr.v4.runtime.atn.PredictionContextCache;
import io.rivulet.org.antlr.v4.runtime.atn.RangeTransition;
import io.rivulet.org.antlr.v4.runtime.atn.RuleStartState;
import io.rivulet.org.antlr.v4.runtime.atn.RuleStopState;
import io.rivulet.org.antlr.v4.runtime.atn.RuleTransition;
import io.rivulet.org.antlr.v4.runtime.atn.SetTransition;
import io.rivulet.org.antlr.v4.runtime.atn.StarBlockStartState;
import io.rivulet.org.antlr.v4.runtime.atn.StarLoopEntryState;
import io.rivulet.org.antlr.v4.runtime.atn.StarLoopbackState;
import io.rivulet.org.antlr.v4.runtime.atn.TokensStartState;
import io.rivulet.org.antlr.v4.runtime.atn.Transition;
import io.rivulet.org.antlr.v4.runtime.atn.WildcardTransition;
import io.rivulet.org.antlr.v4.runtime.dfa.DFAState;
import io.rivulet.org.antlr.v4.runtime.misc.IntervalSet;
import io.rivulet.org.antlr.v4.runtime.misc.NotNull;
import io.rivulet.org.antlr.v4.runtime.misc.Pair;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public abstract class ATNSimulator {
    public static final int SERIALIZED_VERSION = 2;
    @NotNull
    public static final DFAState ERROR = new DFAState(new ATNConfigSet());
    @NotNull
    public final ATN atn;
    protected final PredictionContextCache sharedContextCache;

    public ATNSimulator(@NotNull ATN atn, @NotNull PredictionContextCache sharedContextCache) {
        this.atn = atn;
        this.sharedContextCache = sharedContextCache;
    }

    public abstract void reset();

    public PredictionContext getCachedContext(PredictionContext context) {
        if (this.sharedContextCache == null) {
            return context;
        }
        IdentityHashMap<PredictionContext, PredictionContext> visited = new IdentityHashMap<PredictionContext, PredictionContext>();
        return PredictionContext.getCachedContext(context, this.sharedContextCache, visited);
    }

    /*
     * WARNING - void declaration
     */
    public static ATN deserialize(@NotNull char[] data) {
        void var9_17;
        int version;
        data = (char[])data.clone();
        for (int i = 1; i < data.length; ++i) {
            data[i] = (char)(data[i] - 2);
        }
        ATN atn = new ATN();
        ArrayList<IntervalSet> sets = new ArrayList<IntervalSet>();
        int p = 0;
        if ((version = ATNSimulator.toInt(data[p++])) != SERIALIZED_VERSION) {
            String reason = String.format("Could not deserialize ATN with version %d (expected %d).", version, SERIALIZED_VERSION);
            throw new UnsupportedOperationException(new InvalidClassException(ATN.class.getName(), reason));
        }
        atn.grammarType = ATNSimulator.toInt(data[p++]);
        atn.maxTokenType = ATNSimulator.toInt(data[p++]);
        ArrayList<Pair<LoopEndState, Integer>> loopBackStateNumbers = new ArrayList<Pair<LoopEndState, Integer>>();
        ArrayList<Pair<BlockStartState, Integer>> endStateNumbers = new ArrayList<Pair<BlockStartState, Integer>>();
        int nstates = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= nstates; ++i) {
            int n;
            if ((n = ATNSimulator.toInt(data[p++])) == 0) {
                atn.addState(null);
                continue;
            }
            int ruleIndex = ATNSimulator.toInt(data[p++]);
            ATNState s = ATNSimulator.stateFactory(n, ruleIndex);
            if (n == 12) {
                int loopBackStateNumber = ATNSimulator.toInt(data[p++]);
                loopBackStateNumbers.add(new Pair<LoopEndState, Integer>((LoopEndState)s, loopBackStateNumber));
            } else if (s instanceof BlockStartState) {
                int endStateNumber = ATNSimulator.toInt(data[p++]);
                endStateNumbers.add(new Pair<BlockStartState, Integer>((BlockStartState)s, endStateNumber));
            }
            atn.addState(s);
        }
        for (Pair pair : loopBackStateNumbers) {
            ((LoopEndState)pair.a).loopBackState = atn.states.get((Integer)pair.b);
        }
        for (Pair pair : endStateNumbers) {
            ((BlockStartState)pair.a).endState = (BlockEndState)atn.states.get((Integer)pair.b);
        }
        int numNonGreedyStates = ATNSimulator.toInt(data[p++]);
        boolean bl = false;
        while (var9_17 < numNonGreedyStates) {
            int stateNumber = ATNSimulator.toInt(data[p++]);
            ((DecisionState)atn.states.get((int)stateNumber)).nonGreedy = true;
            ++var9_17;
        }
        int n = ATNSimulator.toInt(data[p++]);
        if (atn.grammarType == 2) {
            atn.ruleToTokenType = new int[n];
            atn.ruleToActionIndex = new int[n];
        }
        atn.ruleToStartState = new RuleStartState[n];
        for (int i = 0; i < n; ++i) {
            int actionIndex;
            int tokenType;
            RuleStartState startState;
            int s = ATNSimulator.toInt(data[p++]);
            atn.ruleToStartState[i] = startState = (RuleStartState)atn.states.get(s);
            if (atn.grammarType != 2) continue;
            atn.ruleToTokenType[i] = tokenType = ATNSimulator.toInt(data[p++]);
            atn.ruleToActionIndex[i] = actionIndex = ATNSimulator.toInt(data[p++]);
        }
        atn.ruleToStopState = new RuleStopState[n];
        for (ATNState state : atn.states) {
            RuleStopState stopState;
            if (!(state instanceof RuleStopState)) continue;
            atn.ruleToStopState[state.ruleIndex] = stopState = (RuleStopState)state;
            atn.ruleToStartState[state.ruleIndex].stopState = stopState;
        }
        int nmodes = ATNSimulator.toInt(data[p++]);
        for (int i = 0; i < nmodes; ++i) {
            int s = ATNSimulator.toInt(data[p++]);
            atn.modeToStartState.add((TokensStartState)atn.states.get(s));
        }
        int nsets = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= nsets; ++i) {
            int nintervals = ATNSimulator.toInt(data[p]);
            ++p;
            IntervalSet set = new IntervalSet(new int[0]);
            sets.add(set);
            for (int j = 1; j <= nintervals; ++j) {
                set.add(ATNSimulator.toInt(data[p]), ATNSimulator.toInt(data[p + 1]));
                p += 2;
            }
        }
        int nedges = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= nedges; ++i) {
            int src = ATNSimulator.toInt(data[p]);
            int trg = ATNSimulator.toInt(data[p + 1]);
            int ttype = ATNSimulator.toInt(data[p + 2]);
            int arg1 = ATNSimulator.toInt(data[p + 3]);
            int arg2 = ATNSimulator.toInt(data[p + 4]);
            int arg3 = ATNSimulator.toInt(data[p + 5]);
            Transition trans = ATNSimulator.edgeFactory(atn, ttype, src, trg, arg1, arg2, arg3, sets);
            ATNState srcState = atn.states.get(src);
            srcState.addTransition(trans);
            p += 6;
        }
        for (ATNState state : atn.states) {
            for (int i = 0; i < state.getNumberOfTransitions(); ++i) {
                Transition t = state.transition(i);
                if (!(t instanceof RuleTransition)) continue;
                RuleTransition ruleTransition = (RuleTransition)t;
                atn.ruleToStopState[ruleTransition.target.ruleIndex].addTransition(new EpsilonTransition(ruleTransition.followState));
            }
        }
        for (ATNState state : atn.states) {
            ATNState target;
            int i;
            ATNState loopbackState;
            if (state instanceof BlockStartState) {
                if (((BlockStartState)state).endState == null) {
                    throw new IllegalStateException();
                }
                if (((BlockStartState)state).endState.startState != null) {
                    throw new IllegalStateException();
                }
                ((BlockStartState)state).endState.startState = (BlockStartState)state;
            }
            if (state instanceof PlusLoopbackState) {
                loopbackState = (PlusLoopbackState)state;
                for (i = 0; i < loopbackState.getNumberOfTransitions(); ++i) {
                    target = loopbackState.transition((int)i).target;
                    if (!(target instanceof PlusBlockStartState)) continue;
                    ((PlusBlockStartState)target).loopBackState = loopbackState;
                }
                continue;
            }
            if (!(state instanceof StarLoopbackState)) continue;
            loopbackState = (StarLoopbackState)state;
            for (i = 0; i < loopbackState.getNumberOfTransitions(); ++i) {
                target = loopbackState.transition((int)i).target;
                if (!(target instanceof StarLoopEntryState)) continue;
                ((StarLoopEntryState)target).loopBackState = loopbackState;
            }
        }
        int ndecisions = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= ndecisions; ++i) {
            int s = ATNSimulator.toInt(data[p++]);
            DecisionState decState = (DecisionState)atn.states.get(s);
            atn.decisionToState.add(decState);
            decState.decision = i - 1;
        }
        ATNSimulator.verifyATN(atn);
        return atn;
    }

    private static void verifyATN(ATN atn) {
        for (ATNState state : atn.states) {
            if (state == null) continue;
            ATNSimulator.checkCondition(state.onlyHasEpsilonTransitions() || state.getNumberOfTransitions() <= 1);
            if (state instanceof PlusBlockStartState) {
                ATNSimulator.checkCondition(((PlusBlockStartState)state).loopBackState != null);
            }
            if (state instanceof StarLoopEntryState) {
                StarLoopEntryState starLoopEntryState = (StarLoopEntryState)state;
                ATNSimulator.checkCondition(starLoopEntryState.loopBackState != null);
                ATNSimulator.checkCondition(starLoopEntryState.getNumberOfTransitions() == 2);
                if (starLoopEntryState.transition((int)0).target instanceof StarBlockStartState) {
                    ATNSimulator.checkCondition(starLoopEntryState.transition((int)1).target instanceof LoopEndState);
                    ATNSimulator.checkCondition(!starLoopEntryState.nonGreedy);
                } else if (starLoopEntryState.transition((int)0).target instanceof LoopEndState) {
                    ATNSimulator.checkCondition(starLoopEntryState.transition((int)1).target instanceof StarBlockStartState);
                    ATNSimulator.checkCondition(starLoopEntryState.nonGreedy);
                } else {
                    throw new IllegalStateException();
                }
            }
            if (state instanceof StarLoopbackState) {
                ATNSimulator.checkCondition(state.getNumberOfTransitions() == 1);
                ATNSimulator.checkCondition(state.transition((int)0).target instanceof StarLoopEntryState);
            }
            if (state instanceof LoopEndState) {
                ATNSimulator.checkCondition(((LoopEndState)state).loopBackState != null);
            }
            if (state instanceof RuleStartState) {
                ATNSimulator.checkCondition(((RuleStartState)state).stopState != null);
            }
            if (state instanceof BlockStartState) {
                ATNSimulator.checkCondition(((BlockStartState)state).endState != null);
            }
            if (state instanceof BlockEndState) {
                ATNSimulator.checkCondition(((BlockEndState)state).startState != null);
            }
            if (state instanceof DecisionState) {
                DecisionState decisionState = (DecisionState)state;
                ATNSimulator.checkCondition(decisionState.getNumberOfTransitions() <= 1 || decisionState.decision >= 0);
                continue;
            }
            ATNSimulator.checkCondition(state.getNumberOfTransitions() <= 1 || state instanceof RuleStopState);
        }
    }

    public static void checkCondition(boolean condition) {
        ATNSimulator.checkCondition(condition, null);
    }

    public static void checkCondition(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static int toInt(char c) {
        return c == '\uffff' ? -1 : (int)c;
    }

    @NotNull
    public static Transition edgeFactory(@NotNull ATN atn, int type, int src, int trg, int arg1, int arg2, int arg3, List<IntervalSet> sets) {
        ATNState target = atn.states.get(trg);
        switch (type) {
            case 1: {
                return new EpsilonTransition(target);
            }
            case 2: {
                return new RangeTransition(target, arg1, arg2);
            }
            case 3: {
                RuleTransition rt = new RuleTransition((RuleStartState)atn.states.get(arg1), arg2, target);
                return rt;
            }
            case 4: {
                PredicateTransition pt = new PredicateTransition(target, arg1, arg2, arg3 != 0);
                return pt;
            }
            case 5: {
                return new AtomTransition(target, arg1);
            }
            case 6: {
                ActionTransition a = new ActionTransition(target, arg1, arg2, arg3 != 0);
                return a;
            }
            case 7: {
                return new SetTransition(target, sets.get(arg1));
            }
            case 8: {
                return new NotSetTransition(target, sets.get(arg1));
            }
            case 9: {
                return new WildcardTransition(target);
            }
        }
        throw new IllegalArgumentException("The specified transition type is not valid.");
    }

    public static ATNState stateFactory(int type, int ruleIndex) {
        ATNState s;
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                s = new BasicState();
                break;
            }
            case 2: {
                s = new RuleStartState();
                break;
            }
            case 3: {
                s = new BasicBlockStartState();
                break;
            }
            case 4: {
                s = new PlusBlockStartState();
                break;
            }
            case 5: {
                s = new StarBlockStartState();
                break;
            }
            case 6: {
                s = new TokensStartState();
                break;
            }
            case 7: {
                s = new RuleStopState();
                break;
            }
            case 8: {
                s = new BlockEndState();
                break;
            }
            case 9: {
                s = new StarLoopbackState();
                break;
            }
            case 10: {
                s = new StarLoopEntryState();
                break;
            }
            case 11: {
                s = new PlusLoopbackState();
                break;
            }
            case 12: {
                s = new LoopEndState();
                break;
            }
            default: {
                String message = String.format("The specified state type %d is not valid.", type);
                throw new IllegalArgumentException(message);
            }
        }
        s.ruleIndex = ruleIndex;
        return s;
    }

    static {
        ATNSimulator.ERROR.stateNumber = Integer.MAX_VALUE;
    }
}

