/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.net.sf.jsqlparser.util.deparser;

import io.rivulet.net.sf.jsqlparser.statement.Block;
import io.rivulet.net.sf.jsqlparser.statement.Commit;
import io.rivulet.net.sf.jsqlparser.statement.SetStatement;
import io.rivulet.net.sf.jsqlparser.statement.ShowStatement;
import io.rivulet.net.sf.jsqlparser.statement.Statement;
import io.rivulet.net.sf.jsqlparser.statement.StatementVisitor;
import io.rivulet.net.sf.jsqlparser.statement.Statements;
import io.rivulet.net.sf.jsqlparser.statement.UseStatement;
import io.rivulet.net.sf.jsqlparser.statement.alter.Alter;
import io.rivulet.net.sf.jsqlparser.statement.comment.Comment;
import io.rivulet.net.sf.jsqlparser.statement.create.index.CreateIndex;
import io.rivulet.net.sf.jsqlparser.statement.create.table.CreateTable;
import io.rivulet.net.sf.jsqlparser.statement.create.view.AlterView;
import io.rivulet.net.sf.jsqlparser.statement.create.view.CreateView;
import io.rivulet.net.sf.jsqlparser.statement.delete.Delete;
import io.rivulet.net.sf.jsqlparser.statement.drop.Drop;
import io.rivulet.net.sf.jsqlparser.statement.execute.Execute;
import io.rivulet.net.sf.jsqlparser.statement.insert.Insert;
import io.rivulet.net.sf.jsqlparser.statement.merge.Merge;
import io.rivulet.net.sf.jsqlparser.statement.replace.Replace;
import io.rivulet.net.sf.jsqlparser.statement.select.Select;
import io.rivulet.net.sf.jsqlparser.statement.select.WithItem;
import io.rivulet.net.sf.jsqlparser.statement.truncate.Truncate;
import io.rivulet.net.sf.jsqlparser.statement.update.Update;
import io.rivulet.net.sf.jsqlparser.statement.upsert.Upsert;
import io.rivulet.net.sf.jsqlparser.statement.values.ValuesStatement;
import io.rivulet.net.sf.jsqlparser.util.deparser.AlterDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.AlterViewDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.CreateIndexDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.CreateTableDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.CreateViewDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.DeleteDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.DropDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.ExecuteDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.InsertDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.ReplaceDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.SelectDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.SetStatementDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.ShowStatementDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.UpdateDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.UpsertDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.UseStatementDeParser;
import io.rivulet.net.sf.jsqlparser.util.deparser.ValuesStatementDeParser;
import java.util.Iterator;

public class StatementDeParser
implements StatementVisitor {
    private ExpressionDeParser expressionDeParser;
    private SelectDeParser selectDeParser;
    protected StringBuilder buffer;

    public StatementDeParser(StringBuilder buffer) {
        this(new ExpressionDeParser(), new SelectDeParser(), buffer);
    }

    public StatementDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder buffer) {
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
        this.buffer = buffer;
    }

    @Override
    public void visit(CreateIndex createIndex) {
        CreateIndexDeParser createIndexDeParser = new CreateIndexDeParser(this.buffer);
        createIndexDeParser.deParse(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this, this.buffer);
        createTableDeParser.deParse(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        CreateViewDeParser createViewDeParser = new CreateViewDeParser(this.buffer);
        createViewDeParser.deParse(createView);
    }

    @Override
    public void visit(AlterView alterView) {
        AlterViewDeParser alterViewDeParser = new AlterViewDeParser(this.buffer);
        alterViewDeParser.deParse(alterView);
    }

    @Override
    public void visit(Delete delete) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        DeleteDeParser deleteDeParser = new DeleteDeParser(this.expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
        DropDeParser dropDeParser = new DropDeParser(this.buffer);
        dropDeParser.deParse(drop);
    }

    @Override
    public void visit(Insert insert) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        InsertDeParser insertDeParser = new InsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
    }

    @Override
    public void visit(Replace replace) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        ReplaceDeParser replaceDeParser = new ReplaceDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        replaceDeParser.deParse(replace);
    }

    @Override
    public void visit(Select select) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = select.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                withItem.accept(this.selectDeParser);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        select.getSelectBody().accept(this.selectDeParser);
    }

    @Override
    public void visit(Truncate truncate) {
        this.buffer.append("TRUNCATE TABLE ");
        this.buffer.append(truncate.getTable());
        if (truncate.getCascade()) {
            this.buffer.append(" CASCADE");
        }
    }

    @Override
    public void visit(Update update) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        UpdateDeParser updateDeParser = new UpdateDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        updateDeParser.deParse(update);
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(Alter alter) {
        AlterDeParser alterDeParser = new AlterDeParser(this.buffer);
        alterDeParser.deParse(alter);
    }

    @Override
    public void visit(Statements stmts) {
        stmts.accept(this);
    }

    @Override
    public void visit(Execute execute) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        ExecuteDeParser executeDeParser = new ExecuteDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        executeDeParser.deParse(execute);
    }

    @Override
    public void visit(SetStatement set) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        SetStatementDeParser setStatementDeparser = new SetStatementDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        setStatementDeparser.deParse(set);
    }

    @Override
    public void visit(Merge merge) {
        this.buffer.append(merge.toString());
    }

    @Override
    public void visit(Commit commit) {
        this.buffer.append(commit.toString());
    }

    @Override
    public void visit(Upsert upsert) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        UpsertDeParser upsertDeParser = new UpsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        upsertDeParser.deParse(upsert);
    }

    @Override
    public void visit(UseStatement use) {
        new UseStatementDeParser(this.buffer).deParse(use);
    }

    @Override
    public void visit(ShowStatement show) {
        new ShowStatementDeParser(this.buffer).deParse(show);
    }

    @Override
    public void visit(Block block) {
        this.buffer.append("BEGIN\n");
        if (block.getStatements() != null) {
            for (Statement stmt : block.getStatements().getStatements()) {
                stmt.accept(this);
                this.buffer.append(";\n");
            }
        }
        this.buffer.append("END");
    }

    @Override
    public void visit(Comment comment) {
        this.buffer.append(comment.toString());
    }

    @Override
    public void visit(ValuesStatement values) {
        this.expressionDeParser.setBuffer(this.buffer);
        new ValuesStatementDeParser(this.expressionDeParser, this.buffer).deParse(values);
    }
}

