/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.net.sf.jsqlparser.util.deparser;

import io.rivulet.net.sf.jsqlparser.expression.AllComparisonExpression;
import io.rivulet.net.sf.jsqlparser.expression.AnalyticExpression;
import io.rivulet.net.sf.jsqlparser.expression.AnyComparisonExpression;
import io.rivulet.net.sf.jsqlparser.expression.BinaryExpression;
import io.rivulet.net.sf.jsqlparser.expression.CaseExpression;
import io.rivulet.net.sf.jsqlparser.expression.CastExpression;
import io.rivulet.net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import io.rivulet.net.sf.jsqlparser.expression.DateValue;
import io.rivulet.net.sf.jsqlparser.expression.DoubleValue;
import io.rivulet.net.sf.jsqlparser.expression.Expression;
import io.rivulet.net.sf.jsqlparser.expression.ExpressionVisitor;
import io.rivulet.net.sf.jsqlparser.expression.ExtractExpression;
import io.rivulet.net.sf.jsqlparser.expression.Function;
import io.rivulet.net.sf.jsqlparser.expression.HexValue;
import io.rivulet.net.sf.jsqlparser.expression.IntervalExpression;
import io.rivulet.net.sf.jsqlparser.expression.JdbcNamedParameter;
import io.rivulet.net.sf.jsqlparser.expression.JdbcParameter;
import io.rivulet.net.sf.jsqlparser.expression.JsonExpression;
import io.rivulet.net.sf.jsqlparser.expression.KeepExpression;
import io.rivulet.net.sf.jsqlparser.expression.LongValue;
import io.rivulet.net.sf.jsqlparser.expression.MySQLGroupConcat;
import io.rivulet.net.sf.jsqlparser.expression.NotExpression;
import io.rivulet.net.sf.jsqlparser.expression.NullValue;
import io.rivulet.net.sf.jsqlparser.expression.NumericBind;
import io.rivulet.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import io.rivulet.net.sf.jsqlparser.expression.OracleHint;
import io.rivulet.net.sf.jsqlparser.expression.Parenthesis;
import io.rivulet.net.sf.jsqlparser.expression.RowConstructor;
import io.rivulet.net.sf.jsqlparser.expression.SignedExpression;
import io.rivulet.net.sf.jsqlparser.expression.StringValue;
import io.rivulet.net.sf.jsqlparser.expression.TimeKeyExpression;
import io.rivulet.net.sf.jsqlparser.expression.TimeValue;
import io.rivulet.net.sf.jsqlparser.expression.TimestampValue;
import io.rivulet.net.sf.jsqlparser.expression.UserVariable;
import io.rivulet.net.sf.jsqlparser.expression.ValueListExpression;
import io.rivulet.net.sf.jsqlparser.expression.WhenClause;
import io.rivulet.net.sf.jsqlparser.expression.WindowElement;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.Division;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import io.rivulet.net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import io.rivulet.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import io.rivulet.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.Between;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.InExpression;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.Matches;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import io.rivulet.net.sf.jsqlparser.schema.Column;
import io.rivulet.net.sf.jsqlparser.schema.Table;
import io.rivulet.net.sf.jsqlparser.statement.select.OrderByElement;
import io.rivulet.net.sf.jsqlparser.statement.select.SelectVisitor;
import io.rivulet.net.sf.jsqlparser.statement.select.SubSelect;
import io.rivulet.net.sf.jsqlparser.statement.select.WithItem;
import io.rivulet.net.sf.jsqlparser.util.deparser.OrderByDeParser;
import java.util.Iterator;
import java.util.List;

public class ExpressionDeParser
implements ExpressionVisitor,
ItemsListVisitor {
    private static final String NOT = "NOT ";
    protected StringBuilder buffer = new StringBuilder();
    private SelectVisitor selectVisitor;
    private boolean useBracketsInExprList = true;
    private OrderByDeParser orderByDeParser = new OrderByDeParser();

    public ExpressionDeParser() {
    }

    public ExpressionDeParser(SelectVisitor selectVisitor, StringBuilder buffer) {
        this(selectVisitor, buffer, new OrderByDeParser());
    }

    ExpressionDeParser(SelectVisitor selectVisitor, StringBuilder buffer, OrderByDeParser orderByDeParser) {
        this.selectVisitor = selectVisitor;
        this.buffer = buffer;
        this.orderByDeParser = orderByDeParser;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(Addition addition) {
        this.visitBinaryExpression(addition, " + ");
    }

    @Override
    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression(andExpression, " AND ");
    }

    @Override
    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        if (between.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" BETWEEN ");
        between.getBetweenExpressionStart().accept(this);
        this.buffer.append(" AND ");
        between.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visitOldOracleJoinBinaryExpression(equalsTo, " = ");
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryExpression(division, " / ");
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.buffer.append(doubleValue.toString());
    }

    @Override
    public void visit(HexValue hexValue) {
        this.buffer.append(hexValue.toString());
    }

    @Override
    public void visit(NotExpression notExpr) {
        this.buffer.append(NOT);
        notExpr.getExpression().accept(this);
    }

    @Override
    public void visit(BitwiseRightShift expr) {
        this.visitBinaryExpression(expr, " >> ");
    }

    @Override
    public void visit(BitwiseLeftShift expr) {
        this.visitBinaryExpression(expr, " << ");
    }

    public void visitOldOracleJoinBinaryExpression(OldOracleJoinBinaryExpression expression, String operator) {
        if (expression.isNot()) {
            this.buffer.append(NOT);
        }
        expression.getLeftExpression().accept(this);
        if (expression.getOldOracleJoinSyntax() == 1) {
            this.buffer.append("(+)");
        }
        this.buffer.append(operator);
        expression.getRightExpression().accept(this);
        if (expression.getOldOracleJoinSyntax() == 2) {
            this.buffer.append("(+)");
        }
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visitOldOracleJoinBinaryExpression(greaterThan, " > ");
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitOldOracleJoinBinaryExpression(greaterThanEquals, " >= ");
    }

    @Override
    public void visit(InExpression inExpression) {
        if (inExpression.getLeftExpression() == null) {
            inExpression.getLeftItemsList().accept(this);
        } else {
            inExpression.getLeftExpression().accept(this);
            if (inExpression.getOldOracleJoinSyntax() == 1) {
                this.buffer.append("(+)");
            }
        }
        if (inExpression.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" IN ");
        inExpression.getRightItemsList().accept(this);
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        this.buffer.append(signedExpression.getSign());
        signedExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        isNullExpression.getLeftExpression().accept(this);
        if (isNullExpression.isUseIsNull()) {
            if (isNullExpression.isNot()) {
                this.buffer.append(" NOT ISNULL");
            } else {
                this.buffer.append(" ISNULL");
            }
        } else if (isNullExpression.isNot()) {
            this.buffer.append(" IS NOT NULL");
        } else {
            this.buffer.append(" IS NULL");
        }
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.buffer.append("?");
        if (jdbcParameter.isUseFixedIndex()) {
            this.buffer.append(jdbcParameter.getIndex());
        }
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression(likeExpression, likeExpression.isCaseInsensitive() ? " ILIKE " : " LIKE ");
        String escape = likeExpression.getEscape();
        if (escape != null) {
            this.buffer.append(" ESCAPE '").append(escape).append('\'');
        }
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        if (existsExpression.isNot()) {
            this.buffer.append("NOT EXISTS ");
        } else {
            this.buffer.append("EXISTS ");
        }
        existsExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(LongValue longValue) {
        this.buffer.append(longValue.getStringValue());
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visitOldOracleJoinBinaryExpression(minorThan, " < ");
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visitOldOracleJoinBinaryExpression(minorThanEquals, " <= ");
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication, " * ");
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visitOldOracleJoinBinaryExpression(notEqualsTo, " " + notEqualsTo.getStringExpression() + " ");
    }

    @Override
    public void visit(NullValue nullValue) {
        this.buffer.append(nullValue.toString());
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression, " OR ");
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        if (parenthesis.isNot()) {
            this.buffer.append(NOT);
        }
        this.buffer.append("(");
        parenthesis.getExpression().accept(this);
        this.buffer.append(")");
    }

    @Override
    public void visit(StringValue stringValue) {
        if (stringValue.getPrefix() != null) {
            this.buffer.append(stringValue.getPrefix());
        }
        this.buffer.append("'").append(stringValue.getValue()).append("'");
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction, " - ");
    }

    private void visitBinaryExpression(BinaryExpression binaryExpression, String operator) {
        if (binaryExpression.isNot()) {
            this.buffer.append(NOT);
        }
        binaryExpression.getLeftExpression().accept(this);
        this.buffer.append(operator);
        binaryExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(SubSelect subSelect) {
        if (subSelect.isUseBrackets()) {
            this.buffer.append("(");
        }
        if (this.selectVisitor != null) {
            if (subSelect.getWithItemsList() != null) {
                this.buffer.append("WITH ");
                Iterator<WithItem> iter = subSelect.getWithItemsList().iterator();
                while (iter.hasNext()) {
                    iter.next().accept(this.selectVisitor);
                    if (iter.hasNext()) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append(" ");
                }
                this.buffer.append(" ");
            }
            subSelect.getSelectBody().accept(this.selectVisitor);
        }
        if (subSelect.isUseBrackets()) {
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(Column tableColumn) {
        Table table = tableColumn.getTable();
        String tableName = null;
        if (table != null) {
            tableName = table.getAlias() != null ? table.getAlias().getName() : table.getFullyQualifiedName();
        }
        if (tableName != null && !tableName.isEmpty()) {
            this.buffer.append(tableName).append(".");
        }
        this.buffer.append(tableColumn.getColumnName());
    }

    @Override
    public void visit(Function function) {
        if (function.isEscaped()) {
            this.buffer.append("{fn ");
        }
        this.buffer.append(function.getName());
        if (function.isAllColumns() && function.getParameters() == null) {
            this.buffer.append("(*)");
        } else if (function.getParameters() == null && function.getNamedParameters() == null) {
            this.buffer.append("()");
        } else {
            boolean oldUseBracketsInExprList = this.useBracketsInExprList;
            if (function.isDistinct()) {
                this.useBracketsInExprList = false;
                this.buffer.append("(DISTINCT ");
            } else if (function.isAllColumns()) {
                this.useBracketsInExprList = false;
                this.buffer.append("(ALL ");
            }
            if (function.getNamedParameters() != null) {
                this.visit(function.getNamedParameters());
            }
            if (function.getParameters() != null) {
                this.visit(function.getParameters());
            }
            this.useBracketsInExprList = oldUseBracketsInExprList;
            if (function.isDistinct() || function.isAllColumns()) {
                this.buffer.append(")");
            }
        }
        if (function.getAttribute() != null) {
            this.buffer.append(".").append(function.getAttribute());
        }
        if (function.getKeep() != null) {
            this.buffer.append(" ").append(function.getKeep());
        }
        if (function.isEscaped()) {
            this.buffer.append("}");
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        if (this.useBracketsInExprList) {
            this.buffer.append("(");
        }
        Iterator<Expression> iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = iter.next();
            expression.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (this.useBracketsInExprList) {
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(NamedExpressionList namedExpressionList) {
        if (this.useBracketsInExprList) {
            this.buffer.append("(");
        }
        List<String> names = namedExpressionList.getNames();
        List<Expression> expressions = namedExpressionList.getExpressions();
        for (int i = 0; i < names.size(); ++i) {
            String name;
            if (i > 0) {
                this.buffer.append(" ");
            }
            if (!(name = names.get(i)).equals("")) {
                this.buffer.append(name);
                this.buffer.append(" ");
            }
            expressions.get(i).accept(this);
        }
        if (this.useBracketsInExprList) {
            this.buffer.append(")");
        }
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }

    @Override
    public void visit(DateValue dateValue) {
        this.buffer.append("{d '").append(dateValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.buffer.append("{ts '").append(timestampValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.buffer.append("{t '").append(timeValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.buffer.append("CASE ");
        Expression switchExp = caseExpression.getSwitchExpression();
        if (switchExp != null) {
            switchExp.accept(this);
            this.buffer.append(" ");
        }
        for (Expression expression : caseExpression.getWhenClauses()) {
            expression.accept(this);
        }
        Expression elseExp = caseExpression.getElseExpression();
        if (elseExp != null) {
            this.buffer.append("ELSE ");
            elseExp.accept(this);
            this.buffer.append(" ");
        }
        this.buffer.append("END");
    }

    @Override
    public void visit(WhenClause whenClause) {
        this.buffer.append("WHEN ");
        whenClause.getWhenExpression().accept(this);
        this.buffer.append(" THEN ");
        whenClause.getThenExpression().accept(this);
        this.buffer.append(" ");
    }

    @Override
    public void visit(AllComparisonExpression allComparisonExpression) {
        this.buffer.append("ALL ");
        allComparisonExpression.getSubSelect().accept(this);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        this.buffer.append(anyComparisonExpression.getAnyType().name()).append(" ");
        anyComparisonExpression.getSubSelect().accept(this);
    }

    @Override
    public void visit(Concat concat) {
        this.visitBinaryExpression(concat, " || ");
    }

    @Override
    public void visit(Matches matches) {
        this.visitOldOracleJoinBinaryExpression(matches, " @@ ");
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr, " | ");
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
    }

    @Override
    public void visit(CastExpression cast) {
        if (cast.isUseCastKeyword()) {
            this.buffer.append("CAST(");
            this.buffer.append(cast.getLeftExpression());
            this.buffer.append(" AS ");
            this.buffer.append(cast.getType());
            this.buffer.append(")");
        } else {
            this.buffer.append(cast.getLeftExpression());
            this.buffer.append("::");
            this.buffer.append(cast.getType());
        }
    }

    @Override
    public void visit(Modulo modulo) {
        this.visitBinaryExpression(modulo, " % ");
    }

    @Override
    public void visit(AnalyticExpression aexpr) {
        String name = aexpr.getName();
        Expression expression = aexpr.getExpression();
        Expression offset = aexpr.getOffset();
        Expression defaultValue = aexpr.getDefaultValue();
        boolean isAllColumns = aexpr.isAllColumns();
        KeepExpression keep = aexpr.getKeep();
        ExpressionList partitionExpressionList = aexpr.getPartitionExpressionList();
        List<OrderByElement> orderByElements = aexpr.getOrderByElements();
        WindowElement windowElement = aexpr.getWindowElement();
        this.buffer.append(name).append("(");
        if (aexpr.isDistinct()) {
            this.buffer.append("DISTINCT ");
        }
        if (expression != null) {
            expression.accept(this);
            if (offset != null) {
                this.buffer.append(", ");
                offset.accept(this);
                if (defaultValue != null) {
                    this.buffer.append(", ");
                    defaultValue.accept(this);
                }
            }
        } else if (isAllColumns) {
            this.buffer.append("*");
        }
        if (aexpr.isIgnoreNulls()) {
            this.buffer.append(" IGNORE NULLS");
        }
        this.buffer.append(") ");
        if (keep != null) {
            keep.accept(this);
            this.buffer.append(" ");
        }
        switch (aexpr.getType()) {
            case WITHIN_GROUP: {
                this.buffer.append("WITHIN GROUP");
                break;
            }
            default: {
                this.buffer.append("OVER");
            }
        }
        this.buffer.append(" (");
        if (partitionExpressionList != null && !partitionExpressionList.getExpressions().isEmpty()) {
            this.buffer.append("PARTITION BY ");
            List<Expression> expressions = partitionExpressionList.getExpressions();
            for (int i = 0; i < expressions.size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                expressions.get(i).accept(this);
            }
            this.buffer.append(" ");
        }
        if (orderByElements != null && !orderByElements.isEmpty()) {
            this.buffer.append("ORDER BY ");
            this.orderByDeParser.setExpressionVisitor(this);
            this.orderByDeParser.setBuffer(this.buffer);
            for (int i = 0; i < orderByElements.size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                this.orderByDeParser.deParseElement(orderByElements.get(i));
            }
            if (windowElement != null) {
                this.buffer.append(' ');
                this.buffer.append(windowElement);
            }
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(ExtractExpression eexpr) {
        this.buffer.append("EXTRACT(").append(eexpr.getName());
        this.buffer.append(" FROM ");
        eexpr.getExpression().accept(this);
        this.buffer.append(')');
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        Iterator<ExpressionList> it = multiExprList.getExprList().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(IntervalExpression iexpr) {
        this.buffer.append(iexpr.toString());
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        this.buffer.append(jdbcNamedParameter.toString());
    }

    @Override
    public void visit(OracleHierarchicalExpression oexpr) {
        this.buffer.append(oexpr.toString());
    }

    @Override
    public void visit(RegExpMatchOperator rexpr) {
        this.visitBinaryExpression(rexpr, " " + rexpr.getStringExpression() + " ");
    }

    @Override
    public void visit(RegExpMySQLOperator rexpr) {
        this.visitBinaryExpression(rexpr, " " + rexpr.getStringExpression() + " ");
    }

    @Override
    public void visit(JsonExpression jsonExpr) {
        this.buffer.append(jsonExpr.toString());
    }

    @Override
    public void visit(JsonOperator jsonExpr) {
        this.visitBinaryExpression(jsonExpr, " " + jsonExpr.getStringExpression() + " ");
    }

    @Override
    public void visit(UserVariable var) {
        this.buffer.append(var.toString());
    }

    @Override
    public void visit(NumericBind bind) {
        this.buffer.append(bind.toString());
    }

    @Override
    public void visit(KeepExpression aexpr) {
        this.buffer.append(aexpr.toString());
    }

    @Override
    public void visit(MySQLGroupConcat groupConcat) {
        this.buffer.append(groupConcat.toString());
    }

    @Override
    public void visit(ValueListExpression valueList) {
        this.buffer.append(valueList.toString());
    }

    @Override
    public void visit(RowConstructor rowConstructor) {
        if (rowConstructor.getName() != null) {
            this.buffer.append(rowConstructor.getName());
        }
        this.buffer.append("(");
        boolean first = true;
        for (Expression expr : rowConstructor.getExprList().getExpressions()) {
            if (first) {
                first = false;
            } else {
                this.buffer.append(", ");
            }
            expr.accept(this);
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(OracleHint hint) {
        this.buffer.append(hint.toString());
    }

    @Override
    public void visit(TimeKeyExpression timeKeyExpression) {
        this.buffer.append(timeKeyExpression.toString());
    }

    @Override
    public void visit(DateTimeLiteralExpression literal) {
        this.buffer.append(literal.toString());
    }
}

