/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.net.sf.jsqlparser.util;

import io.rivulet.net.sf.jsqlparser.JSQLParserException;
import io.rivulet.net.sf.jsqlparser.expression.Expression;
import io.rivulet.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import io.rivulet.net.sf.jsqlparser.schema.Table;
import io.rivulet.net.sf.jsqlparser.statement.select.AllColumns;
import io.rivulet.net.sf.jsqlparser.statement.select.Join;
import io.rivulet.net.sf.jsqlparser.statement.select.PlainSelect;
import io.rivulet.net.sf.jsqlparser.statement.select.Select;
import io.rivulet.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import io.rivulet.net.sf.jsqlparser.statement.select.SelectItem;
import io.rivulet.net.sf.jsqlparser.statement.select.SelectVisitor;
import io.rivulet.net.sf.jsqlparser.statement.select.SetOperationList;
import io.rivulet.net.sf.jsqlparser.statement.select.WithItem;
import io.rivulet.net.sf.jsqlparser.statement.values.ValuesStatement;
import java.util.ArrayList;
import java.util.List;

public final class SelectUtils {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";

    private SelectUtils() {
    }

    public static Select buildSelectFromTableAndExpressions(Table table, Expression ... expr) {
        SelectItem[] list = new SelectItem[expr.length];
        for (int i = 0; i < expr.length; ++i) {
            list[i] = new SelectExpressionItem(expr[i]);
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, list);
    }

    public static Select buildSelectFromTableAndExpressions(Table table, String ... expr) throws JSQLParserException {
        SelectItem[] list = new SelectItem[expr.length];
        for (int i = 0; i < expr.length; ++i) {
            list[i] = new SelectExpressionItem(CCJSqlParserUtil.parseExpression(expr[i]));
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, list);
    }

    public static Select buildSelectFromTableAndSelectItems(Table table, SelectItem ... selectItems) {
        Select select = new Select();
        PlainSelect body = new PlainSelect();
        body.addSelectItems(selectItems);
        body.setFromItem(table);
        select.setSelectBody(body);
        return select;
    }

    public static Select buildSelectFromTable(Table table) {
        return SelectUtils.buildSelectFromTableAndSelectItems(table, new AllColumns());
    }

    public static void addExpression(Select select, final Expression expr) {
        select.getSelectBody().accept(new SelectVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                plainSelect.getSelectItems().add(new SelectExpressionItem(expr));
            }

            @Override
            public void visit(SetOperationList setOpList) {
                throw new UnsupportedOperationException(SelectUtils.NOT_SUPPORTED_YET);
            }

            @Override
            public void visit(WithItem withItem) {
                throw new UnsupportedOperationException(SelectUtils.NOT_SUPPORTED_YET);
            }

            @Override
            public void visit(ValuesStatement aThis) {
                throw new UnsupportedOperationException(SelectUtils.NOT_SUPPORTED_YET);
            }
        });
    }

    public static Join addJoin(Select select, Table table, Expression onExpression) {
        if (select.getSelectBody() instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
            List<Join> joins = plainSelect.getJoins();
            if (joins == null) {
                joins = new ArrayList<Join>();
                plainSelect.setJoins(joins);
            }
            Join join = new Join();
            join.setRightItem(table);
            join.setOnExpression(onExpression);
            joins.add(join);
            return join;
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public static void addGroupBy(Select select, final Expression expr) {
        select.getSelectBody().accept(new SelectVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                plainSelect.addGroupByColumnReference(expr);
            }

            @Override
            public void visit(SetOperationList setOpList) {
                throw new UnsupportedOperationException(SelectUtils.NOT_SUPPORTED_YET);
            }

            @Override
            public void visit(WithItem withItem) {
                throw new UnsupportedOperationException(SelectUtils.NOT_SUPPORTED_YET);
            }

            @Override
            public void visit(ValuesStatement aThis) {
                throw new UnsupportedOperationException(SelectUtils.NOT_SUPPORTED_YET);
            }
        });
    }
}

