/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.net.sf.jsqlparser.statement.select;

import io.rivulet.net.sf.jsqlparser.expression.Alias;
import io.rivulet.net.sf.jsqlparser.expression.Expression;
import io.rivulet.net.sf.jsqlparser.expression.ExpressionVisitor;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import io.rivulet.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import io.rivulet.net.sf.jsqlparser.statement.select.FromItem;
import io.rivulet.net.sf.jsqlparser.statement.select.FromItemVisitor;
import io.rivulet.net.sf.jsqlparser.statement.select.Pivot;
import io.rivulet.net.sf.jsqlparser.statement.select.SelectBody;
import io.rivulet.net.sf.jsqlparser.statement.select.WithItem;
import java.util.Iterator;
import java.util.List;

public class SubSelect
extends ASTNodeAccessImpl
implements FromItem,
Expression,
ItemsList {
    private SelectBody selectBody;
    private Alias alias;
    private boolean useBrackets = true;
    private List<WithItem> withItemsList;
    private Pivot pivot;

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    public SelectBody getSelectBody() {
        return this.selectBody;
    }

    public void setSelectBody(SelectBody body) {
        this.selectBody = body;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    public boolean isUseBrackets() {
        return this.useBrackets;
    }

    public void setUseBrackets(boolean useBrackets) {
        this.useBrackets = useBrackets;
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> withItemsList) {
        this.withItemsList = withItemsList;
    }

    @Override
    public void accept(ItemsListVisitor itemsListVisitor) {
        itemsListVisitor.visit(this);
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        if (this.useBrackets) {
            retval.append("(");
        }
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            retval.append("WITH ");
            Iterator<WithItem> iter = this.withItemsList.iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                retval.append(withItem);
                if (iter.hasNext()) {
                    retval.append(",");
                }
                retval.append(" ");
            }
        }
        retval.append(this.selectBody);
        if (this.useBrackets) {
            retval.append(")");
        }
        if (this.alias != null) {
            retval.append(this.alias.toString());
        }
        if (this.pivot != null) {
            retval.append(" ").append(this.pivot);
        }
        return retval.toString();
    }
}

