/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.net.sf.jsqlparser.statement.execute;

import io.rivulet.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import io.rivulet.net.sf.jsqlparser.statement.Statement;
import io.rivulet.net.sf.jsqlparser.statement.StatementVisitor;
import io.rivulet.net.sf.jsqlparser.statement.select.PlainSelect;
import java.util.List;

public class Execute
implements Statement {
    private EXEC_TYPE execType = EXEC_TYPE.EXECUTE;
    private String name;
    private ExpressionList exprList;
    private boolean parenthesis = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(List<String> names) {
        for (String item : names) {
            if (this.name != null) {
                this.name = this.name + "." + item;
                continue;
            }
            this.name = item;
        }
    }

    public ExpressionList getExprList() {
        return this.exprList;
    }

    public void setExprList(ExpressionList exprList) {
        this.exprList = exprList;
    }

    public EXEC_TYPE getExecType() {
        return this.execType;
    }

    public void setExecType(EXEC_TYPE execType) {
        this.execType = execType;
    }

    public boolean isParenthesis() {
        return this.parenthesis;
    }

    public void setParenthesis(boolean parenthesis) {
        this.parenthesis = parenthesis;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        return this.execType.name() + " " + this.name + (this.exprList != null && this.exprList.getExpressions() != null ? " " + PlainSelect.getStringList(this.exprList.getExpressions(), true, this.parenthesis) : "");
    }

    public static enum EXEC_TYPE {
        EXECUTE,
        EXEC,
        CALL;

    }
}

