/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.net.sf.jsqlparser.statement.create.index;

import io.rivulet.net.sf.jsqlparser.schema.Table;
import io.rivulet.net.sf.jsqlparser.statement.Statement;
import io.rivulet.net.sf.jsqlparser.statement.StatementVisitor;
import io.rivulet.net.sf.jsqlparser.statement.create.table.Index;
import java.util.Iterator;

public class CreateIndex
implements Statement {
    private Table table;
    private Index index;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE ");
        if (this.index.getType() != null) {
            buffer.append(this.index.getType());
            buffer.append(" ");
        }
        buffer.append("INDEX ");
        buffer.append(this.index.getName());
        buffer.append(" ON ");
        buffer.append(this.table.getFullyQualifiedName());
        if (this.index.getColumnsNames() != null) {
            buffer.append(" (");
            Iterator<String> iter = this.index.getColumnsNames().iterator();
            while (iter.hasNext()) {
                String columnName = iter.next();
                buffer.append(columnName);
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        }
        return buffer.toString();
    }
}

