/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.net.sf.jsqlparser.schema;

import io.rivulet.net.sf.jsqlparser.expression.Alias;
import io.rivulet.net.sf.jsqlparser.expression.MySQLIndexHint;
import io.rivulet.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import io.rivulet.net.sf.jsqlparser.schema.Database;
import io.rivulet.net.sf.jsqlparser.schema.MultiPartName;
import io.rivulet.net.sf.jsqlparser.statement.select.FromItem;
import io.rivulet.net.sf.jsqlparser.statement.select.FromItemVisitor;
import io.rivulet.net.sf.jsqlparser.statement.select.IntoTableVisitor;
import io.rivulet.net.sf.jsqlparser.statement.select.Pivot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Table
extends ASTNodeAccessImpl
implements FromItem,
MultiPartName {
    private static final int NAME_IDX = 0;
    private static final int SCHEMA_IDX = 1;
    private static final int DATABASE_IDX = 2;
    private static final int SERVER_IDX = 3;
    private List<String> partItems = new ArrayList<String>();
    private Alias alias;
    private Pivot pivot;
    private MySQLIndexHint hint;

    public Table() {
    }

    public Table(String name) {
        this.setIndex(0, name);
    }

    public Table(String schemaName, String name) {
        this.setIndex(0, name);
        this.setIndex(1, schemaName);
    }

    public Table(Database database, String schemaName, String name) {
        this.setIndex(0, name);
        this.setIndex(1, schemaName);
        this.setIndex(2, database.getDatabaseName());
        this.setIndex(3, database.getServer().getFullyQualifiedName());
    }

    public Table(List<String> partItems) {
        this.partItems = new ArrayList<String>(partItems);
        Collections.reverse(this.partItems);
    }

    public Database getDatabase() {
        return new Database(this.getIndex(2));
    }

    public void setDatabase(Database database) {
        this.setIndex(2, database.getDatabaseName());
    }

    public String getSchemaName() {
        return this.getIndex(1);
    }

    public void setSchemaName(String string) {
        this.setIndex(1, string);
    }

    public String getName() {
        return this.getIndex(0);
    }

    public void setName(String string) {
        this.setIndex(0, string);
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    private void setIndex(int idx, String value) {
        for (int i = 0; i < idx - this.partItems.size() + 1; ++i) {
            this.partItems.add(null);
        }
        this.partItems.set(idx, value);
    }

    private String getIndex(int idx) {
        if (idx < this.partItems.size()) {
            return this.partItems.get(idx);
        }
        return null;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder fqn = new StringBuilder();
        for (int i = this.partItems.size() - 1; i >= 0; --i) {
            String part = this.partItems.get(i);
            if (part == null) {
                part = "";
            }
            fqn.append(part);
            if (i == 0) continue;
            fqn.append(".");
        }
        return fqn.toString();
    }

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    public void accept(IntoTableVisitor intoTableVisitor) {
        intoTableVisitor.visit(this);
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    public MySQLIndexHint getIndexHint() {
        return this.hint;
    }

    public void setHint(MySQLIndexHint hint) {
        this.hint = hint;
    }

    public String toString() {
        return this.getFullyQualifiedName() + (this.alias != null ? this.alias.toString() : "") + (this.pivot != null ? " " + this.pivot : "") + (this.hint != null ? this.hint.toString() : "");
    }
}

