/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.net.sf.jsqlparser.expression;

import io.rivulet.net.sf.jsqlparser.expression.Expression;
import io.rivulet.net.sf.jsqlparser.expression.ExpressionVisitor;
import io.rivulet.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleHint
extends ASTNodeAccessImpl
implements Expression {
    private static final Pattern SINGLE_LINE = Pattern.compile("--\\+ *([^ ].*[^ ])");
    private static final Pattern MULTI_LINE = Pattern.compile("\\/\\*\\+ *([^ ].*[^ ]) *\\*+\\/", 40);
    private String value;
    private boolean singleLine = false;

    public static boolean isHintMatch(String comment) {
        return SINGLE_LINE.matcher(comment).find() || MULTI_LINE.matcher(comment).find();
    }

    public final void setComment(String comment) {
        Matcher m = SINGLE_LINE.matcher(comment);
        if (m.find()) {
            this.value = m.group(1);
            this.singleLine = true;
            return;
        }
        m = MULTI_LINE.matcher(comment);
        if (m.find()) {
            this.value = m.group(1);
            this.singleLine = false;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSingleLine() {
        return this.singleLine;
    }

    public void setSingleLine(boolean singleLine) {
        this.singleLine = singleLine;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        if (this.singleLine) {
            return "--+ " + this.value + "\n";
        }
        return "/*+ " + this.value + " */";
    }
}

