/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.net.sf.jsqlparser.expression;

import io.rivulet.net.sf.jsqlparser.expression.Expression;
import io.rivulet.net.sf.jsqlparser.expression.ExpressionVisitor;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import io.rivulet.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import io.rivulet.net.sf.jsqlparser.statement.select.OrderByElement;
import io.rivulet.net.sf.jsqlparser.statement.select.PlainSelect;
import java.util.List;

public class MySQLGroupConcat
extends ASTNodeAccessImpl
implements Expression {
    private ExpressionList expressionList;
    private boolean distinct = false;
    private List<OrderByElement> orderByElements;
    private String separator;

    public ExpressionList getExpressionList() {
        return this.expressionList;
    }

    public void setExpressionList(ExpressionList expressionList) {
        this.expressionList = expressionList;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GROUP_CONCAT(");
        if (this.isDistinct()) {
            b.append("DISTINCT ");
        }
        b.append(PlainSelect.getStringList(this.expressionList.getExpressions(), true, false));
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            b.append(" ORDER BY ");
            for (int i = 0; i < this.orderByElements.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.orderByElements.get(i).toString());
            }
        }
        if (this.separator != null) {
            b.append(" SEPARATOR ").append(this.separator);
        }
        b.append(")");
        return b.toString();
    }
}

