/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.server;

import io.rivulet.internal.server.EmbeddedServer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.io.FileUtils;
import org.apache.coyote.http11.Http11NioProtocol;

public class TomcatEmbeddedServer
extends EmbeddedServer {
    private Tomcat tomcat;

    protected TomcatEmbeddedServer(String[] args) {
        super(args);
    }

    @Override
    protected int getPort() {
        return this.tomcat.getConnector().getLocalPort();
    }

    @Override
    public void addWebApp(String warFilePath, String shortName) throws IOException {
        if (addedWebApps.add(shortName)) {
            TomcatEmbeddedServer.unzipWar(warFilePath, shortName);
            this.tomcat.addWebapp("/" + shortName, new File(webAppsBaseDir, shortName).getCanonicalPath());
        }
    }

    @Override
    public void addWebApp(String name) throws Exception {
        if (addedWebApps.add(name)) {
            String warFile = webAppsWarDir + "/" + name + ".war";
            TomcatEmbeddedServer.unzipWar(warFile, name);
            this.tomcat.addWebapp("/" + name, new File(webAppsBaseDir, name).getCanonicalPath());
            System.out.println("Deployed: /" + name);
        }
    }

    @Override
    protected void startWebServer() {
        try {
            this.tomcat = new Tomcat();
            this.tomcat.setBaseDir(tomcatBaseDir);
            this.tomcat.getHost().setAppBase(tomcatBaseDir);
            String protocol = Http11NioProtocol.class.getName();
            Connector connector = new Connector(protocol);
            connector.setAttribute("address", InetAddress.getByName("localhost").getHostAddress());
            connector.setPort(this.tomcatPort);
            connector.setProperty("relaxedPathChars", "<>`");
            connector.setProperty("relaxedQueryChars", "<>`");
            connector.setProperty("maxThreads", "20");
            this.tomcat.getService().addConnector(connector);
            this.tomcat.setConnector(connector);
            this.tomcat.getHost().setDeployOnStartup(true);
            this.tomcat.getHost().setAutoDeploy(true);
            if (!Boolean.getBoolean("DEBUG")) {
                this.tomcat.setSilent(true);
                System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
                TomcatEmbeddedServer.replaceRootLoggerHandlers();
            }
            this.tomcat.enableNaming();
            this.tomcat.init();
            this.tomcat.start();
            Runnable shutdown = new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            if (TomcatEmbeddedServer.this.tomcat.getServer() != null && TomcatEmbeddedServer.this.tomcat.getServer().getState() != LifecycleState.DESTROYED) {
                                if (TomcatEmbeddedServer.this.tomcat.getServer().getState() != LifecycleState.STOPPED) {
                                    TomcatEmbeddedServer.this.tomcat.stop();
                                }
                                TomcatEmbeddedServer.this.tomcat.destroy();
                                TomcatEmbeddedServer.this.tomcat = null;
                            }
                        }
                        finally {
                            FileUtils.deleteDirectory(new File(EmbeddedServer.tomcatBaseDir));
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(shutdown));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

