/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.server;

import edu.columbia.cs.psl.phosphor.struct.PowerSetTree;
import io.rivulet.PhosphorHttpRequest;
import io.rivulet.fuzz.RerunProgress;
import io.rivulet.fuzz.RivuletJUnitCoreProvider;
import io.rivulet.fuzz.maven.surefire.junitcore.BaseTaintTrackingTestListener;
import io.rivulet.internal.RivuletAutoTaintWrapper;
import io.rivulet.internal.ViolationReport;

public class ServerTaintTrackingTestListener
extends BaseTaintTrackingTestListener {
    public ServerTaintTrackingTestListener(Object target, String rerunConfigsPath, String violationReportsPath, String criticalReproductionPath, RerunProgress rerunProgress) {
        super(target, rerunConfigsPath, violationReportsPath, criticalReproductionPath, rerunProgress);
        RivuletAutoTaintWrapper.setRunningJUnitTests(true);
    }

    public void testSetStarted(String className) {
        this.setReportFileInfo(className);
        this.violationNumber.set(0);
        this.violationReport = new ViolationReport();
    }

    public void testSetEnded(String className) {
        PowerSetTree.getInstance().reset();
        if (this.currentReportFile == null) {
            this.setReportFileInfo("SKIPPED");
        }
        this.violationReport.writeJsonToFile(this.currentReportFile);
        if (!RivuletJUnitCoreProvider.isReruns && !this.generatedRerunConfigs.isEmpty()) {
            ServerTaintTrackingTestListener.writeToAppendingObjectStream(this.rerunConfigsDirectory, className + ".rawReruns", this.generatedRerunConfigs);
            this.generatedRerunConfigs.clear();
        }
    }

    public void testStarted(String className, String methodName) {
        PhosphorHttpRequest.clearInterceptedRequests();
        PowerSetTree.getInstance().reset();
        RivuletAutoTaintWrapper.resetForNextTest();
        if (className != null && methodName != null) {
            this.violationReport.reportTestWasRun(className, methodName);
        }
    }

    public int testError(String className, String methodName) {
        int numViolations = this.addTaintInfo(className, methodName);
        if (RivuletJUnitCoreProvider.isReruns) {
            this.reportRerunResult("Error", className, methodName, numViolations);
        }
        return numViolations;
    }

    public int testFailed(String className, String methodName) {
        int numViolations = this.addTaintInfo(className, methodName);
        if (RivuletJUnitCoreProvider.isReruns) {
            this.reportRerunResult("Failed", className, methodName, numViolations);
        }
        return numViolations;
    }

    public int testSucceeded(String className, String methodName) {
        int numViolations = this.addTaintInfo(className, methodName);
        if (RivuletJUnitCoreProvider.isReruns) {
            this.reportRerunResult("Succeeded", className, methodName, numViolations);
        }
        return numViolations;
    }
}

