/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.server;

import edu.columbia.cs.psl.phosphor.BasicSourceSinkManager;
import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.Instrumenter;
import io.rivulet.fuzz.RerunProgress;
import io.rivulet.internal.RivuletAutoTaintWrapper;
import io.rivulet.internal.fuzz.generator.RerunGeneratorWrapper;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import io.rivulet.internal.server.EmbeddedMessageImpl;
import io.rivulet.internal.server.ServerTaintTrackingTestListener;
import io.rivulet.internal.server.TomcatEmbeddedServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.http.Consts;
import org.apache.tomcat.util.http.fileupload.IOUtils;

public abstract class EmbeddedServer {
    protected static final String tomcatBaseDir = System.getProperty("tomcat.base.directory", "tomcat");
    protected static final String webAppsBaseDir = System.getProperty("webapps.base.directory", "webapps");
    protected static final String webAppsWarDir = ".." + File.separator + "experiments" + File.separator + "apache-tomcat-8.0.47" + File.separator + "webapps";
    protected static final HashSet<String> addedWebApps = new HashSet();
    private static RerunGeneratorWrapper sinksProvider = null;
    protected int tomcatPort;
    protected int socketPort;
    private Thread clientCommunicationHandlingThread;
    private ServerSocket receiverSocket;
    private ServerTaintTrackingTestListener taintTrackingTestListener;
    private RerunProgress rerunProgress = new RerunProgress();

    protected EmbeddedServer(String[] args) {
        this.tomcatPort = Integer.valueOf(args[0]);
        this.socketPort = Integer.valueOf(args[1]);
    }

    protected void doneAddingWebApps() throws Exception {
    }

    public static void main(String[] args) {
        TomcatEmbeddedServer server = new TomcatEmbeddedServer(args);
        server.start();
        if (args.length > 2) {
            try {
                ((EmbeddedServer)server).addWebApp(args[2], args[3]);
                server.doneAddingWebApps();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Handler createFileHandler() throws IOException {
        File baseDirFile = new File(tomcatBaseDir);
        if (!baseDirFile.isDirectory() && !baseDirFile.mkdirs()) {
            System.err.println("Failed to make base directory for embedded tomcat.");
        }
        FileHandler fileHandler = new FileHandler(tomcatBaseDir + File.separator + "catalina.out", true);
        fileHandler.setFormatter(new SimpleFormatter());
        fileHandler.setLevel(Level.INFO);
        ((Handler)fileHandler).setEncoding("UTF-8");
        return fileHandler;
    }

    protected static void replaceRootLoggerHandlers() throws IOException {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        rootLogger.setUseParentHandlers(false);
        for (Handler h : rootLogger.getHandlers()) {
            h.setLevel(Level.OFF);
        }
        rootLogger.addHandler(EmbeddedServer.createFileHandler());
    }

    protected static void unzipWar(String warFile, String name) throws IOException {
        File dir = new File(webAppsBaseDir, name);
        if (!dir.isDirectory()) {
            File webAppWar = new File(warFile);
            if (!webAppWar.isFile()) {
                throw new RuntimeException("Could not find war file for: " + name);
            }
            try (ZipFile zipFile = new ZipFile(webAppWar);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    File entryDestination = new File(dir, entry.getName());
                    if (entry.isDirectory()) {
                        if (entryDestination.isDirectory() || entryDestination.mkdirs()) continue;
                        throw new RuntimeException("Failed to make directory for: " + entryDestination);
                    }
                    if (!entryDestination.getParentFile().isDirectory() && !entryDestination.getParentFile().mkdirs()) {
                        throw new RuntimeException("Failed to make directory for: " + entryDestination.getParentFile());
                    }
                    InputStream in = zipFile.getInputStream(entry);
                    FileOutputStream out = new FileOutputStream(entryDestination);
                    IOUtils.copy(in, out);
                    IOUtils.closeQuietly(in);
                    ((OutputStream)out).close();
                }
            }
        }
    }

    private static void writeLog4JProperties(File file) throws IOException {
        String content = "log4j.rootLogger=OFF, stdout\nlog4j.appender.stdout=org.apache.log4j.ConsoleAppender\nlog4j.appender.stdout.layout=org.apache.log4j.SimpleLayout\n";
        FileUtils.writeStringToFile(file, content, Consts.UTF_8, false);
    }

    public abstract void addWebApp(String var1, String var2) throws IOException;

    public abstract void addWebApp(String var1) throws Exception;

    protected abstract void startWebServer();

    protected abstract int getPort();

    public void start() {
        try {
            this.startWebServer();
            this.receiverSocket = new ServerSocket(this.socketPort);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.clientCommunicationHandlingThread = new Thread(() -> {
            try {
                System.out.println("Control port: " + this.receiverSocket.getLocalPort());
                System.out.println("Tomcat port: " + this.getPort());
                while (true) {
                    Socket channel = this.receiverSocket.accept();
                    Thread clientThread = new Thread(() -> {
                        try {
                            try {
                                DataInputStream is = new DataInputStream(new BufferedInputStream(channel.getInputStream()));
                                DataOutputStream os = new DataOutputStream(new BufferedOutputStream(channel.getOutputStream()));
                                PrintWriter outputPrinter = new PrintWriter(channel.getOutputStream());
                                while (true) {
                                    EmbeddedMessageImpl message = EmbeddedMessageImpl.fromInput(is);
                                    message.apply(this, os);
                                }
                            }
                            catch (EOFException ex) {
                                channel.close();
                                return;
                            }
                            catch (ClassNotFoundException e) {
                                try {
                                    e.printStackTrace();
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    channel.close();
                                }
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    });
                    clientThread.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        });
        this.clientCommunicationHandlingThread.setDaemon(true);
        this.clientCommunicationHandlingThread.start();
    }

    public ServerTaintTrackingTestListener getTaintTrackingTestListener() {
        return this.taintTrackingTestListener;
    }

    public void initListener(String rerunConfigsPath, String violationReportsPath, String criticalReproductionPath) {
        this.taintTrackingTestListener = new ServerTaintTrackingTestListener(this, rerunConfigsPath, violationReportsPath, criticalReproductionPath, new RerunProgress());
    }

    public void setRerunConfigAndResetAutoTaint(TestRerunConfiguration config) {
        block8: {
            RivuletAutoTaintWrapper.setCurrentRerunConfig(config);
            if (config.getAutoTainterClass() != null) {
                try {
                    RerunGeneratorWrapper generator;
                    Configuration.autoTainter = config.getAutoTainterClass().newInstance();
                    if (!(Configuration.autoTainter instanceof RerunGeneratorWrapper) || (generator = (RerunGeneratorWrapper)Configuration.autoTainter).equals(sinksProvider)) break block8;
                    if (generator.getTargetedBaseSinks() != null) {
                        sinksProvider = generator;
                        BasicSourceSinkManager.replaceAutoTaintMethods(generator.getTargetedBaseSinks(), BasicSourceSinkManager.AutoTaint.SINK);
                    } else if (sinksProvider != null) {
                        sinksProvider = null;
                        BasicSourceSinkManager.replaceAutoTaintMethods(Instrumenter.sinksFile, BasicSourceSinkManager.AutoTaint.SINK);
                    }
                    break block8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Configuration.autoTainter = new RivuletAutoTaintWrapper();
                    if (sinksProvider != null) {
                        sinksProvider = null;
                        BasicSourceSinkManager.replaceAutoTaintMethods(Instrumenter.sinksFile, BasicSourceSinkManager.AutoTaint.SINK);
                    }
                    break block8;
                }
            }
            Configuration.autoTainter = new RivuletAutoTaintWrapper();
            if (sinksProvider != null) {
                sinksProvider = null;
                BasicSourceSinkManager.replaceAutoTaintMethods(Instrumenter.sinksFile, BasicSourceSinkManager.AutoTaint.SINK);
            }
        }
    }
}

