/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.server;

import io.rivulet.fuzz.RivuletJUnitCoreProvider;
import io.rivulet.internal.EmbeddedMessage;
import io.rivulet.internal.RivuletAutoTaintWrapper;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import io.rivulet.internal.server.EmbeddedServer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class EmbeddedMessageImpl
extends EmbeddedMessage {
    public static EmbeddedMessageImpl fromInput(DataInputStream is) throws IOException, ClassNotFoundException {
        EmbeddedMessageImpl ret = new EmbeddedMessageImpl();
        ret.type = EmbeddedMessage.MessageType.values()[is.readByte()];
        int len = is.readInt();
        if (len == -1) {
            ObjectInputStream ois = new ObjectInputStream(is);
            ret.arg = ois.readObject();
        } else {
            ret.args = new String[len];
            for (int i = 0; i < ret.args.length; ++i) {
                ret.args[i] = is.readUTF();
            }
        }
        return ret;
    }

    public void apply(EmbeddedServer embeddedServer, DataOutputStream outputStream) throws IOException {
        switch (this.type) {
            case DEPLOY_WEBAPP: {
                embeddedServer.addWebApp(this.args[1], this.args[0]);
                outputStream.writeByte(EmbeddedMessage.MessageType.OK.ordinal());
                outputStream.flush();
                break;
            }
            case VIOLATIONS_INQUIRY: {
                outputStream.writeInt(RivuletAutoTaintWrapper.getViolations().size());
                outputStream.flush();
                break;
            }
            case SET_RERUNS_MODE: {
                boolean v;
                RivuletJUnitCoreProvider.isReruns = v = Boolean.valueOf(this.args[0]).booleanValue();
                outputStream.writeByte(EmbeddedMessage.MessageType.OK.ordinal());
                outputStream.flush();
                break;
            }
            case SET_RERUN_CONFIG: {
                embeddedServer.setRerunConfigAndResetAutoTaint((TestRerunConfiguration)this.arg);
                outputStream.writeByte(EmbeddedMessage.MessageType.OK.ordinal());
                outputStream.flush();
                break;
            }
            case INIT_LISTENER: {
                embeddedServer.initListener(this.args[0], this.args[1], this.args.length > 2 ? this.args[2] : null);
                outputStream.writeByte(EmbeddedMessage.MessageType.OK.ordinal());
                outputStream.flush();
                break;
            }
            case TEST_SET_STARTED: {
                embeddedServer.getTaintTrackingTestListener().testSetStarted(this.args[0]);
                outputStream.writeByte(EmbeddedMessage.MessageType.OK.ordinal());
                outputStream.flush();
                break;
            }
            case TEST_SET_ENDED: {
                embeddedServer.getTaintTrackingTestListener().testSetEnded(this.args.length == 0 ? null : this.args[0]);
                outputStream.writeByte(EmbeddedMessage.MessageType.OK.ordinal());
                outputStream.flush();
                break;
            }
            case TEST_STARTED: {
                embeddedServer.getTaintTrackingTestListener().testStarted(this.args[0], this.args[1]);
                outputStream.writeByte(EmbeddedMessage.MessageType.OK.ordinal());
                outputStream.flush();
                break;
            }
            case TEST_ERRORED: {
                int numViolations = embeddedServer.getTaintTrackingTestListener().testError(this.args[0], this.args[1]);
                outputStream.writeInt(numViolations);
                outputStream.flush();
                break;
            }
            case TEST_FAILED: {
                int numViolations = embeddedServer.getTaintTrackingTestListener().testFailed(this.args[0], this.args[1]);
                outputStream.writeInt(numViolations);
                outputStream.flush();
                break;
            }
            case TEST_SUCCEEDED: {
                int numViolations = embeddedServer.getTaintTrackingTestListener().testSucceeded(this.args[0], this.args[1]);
                outputStream.writeInt(numViolations);
                outputStream.flush();
                break;
            }
            case OK: {
                break;
            }
            case CHECK_AND_CLEAR_REACHED_SINK: {
                outputStream.writeBoolean(RivuletAutoTaintWrapper.checkAndClearReachedSink());
                outputStream.flush();
                break;
            }
            case GET_RERUN_CONFIG: {
                ObjectOutputStream oos = new ObjectOutputStream(outputStream);
                oos.writeObject(RivuletAutoTaintWrapper.getCurrentRerunConfig());
                oos.flush();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

