/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.rerun;

import edu.columbia.cs.psl.phosphor.runtime.TaintSourceWrapper;
import io.rivulet.ReplacementComparator;
import io.rivulet.internal.SourceInfoTaintLabel;
import io.rivulet.internal.rerun.Replacement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class TestRerunConfiguration
implements Serializable {
    private static final long serialVersionUID = -4841743631847606347L;
    private String testClass;
    private String testMethod;
    private final Class<? extends TaintSourceWrapper> autoTainterClass;
    private final TreeSet<String> violationUIDs;
    private final ArrayList<Replacement> replacements;

    protected TestRerunConfiguration(String testClass, String testMethod, Class<? extends TaintSourceWrapper> autoTainterClass, Collection<String> violationUIDs, Set<? extends Replacement> replacements) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.autoTainterClass = autoTainterClass;
        this.violationUIDs = new TreeSet<String>(violationUIDs);
        this.replacements = new ArrayList<Replacement>(replacements);
        this.replacements.sort(ReplacementComparator.getInstance());
    }

    public String getTestClass() {
        return this.testClass;
    }

    public String getTestMethod() {
        return this.testMethod;
    }

    public Class<? extends TaintSourceWrapper> getAutoTainterClass() {
        return this.autoTainterClass;
    }

    public Set<String> getViolationUIDs() {
        return this.violationUIDs;
    }

    public List<Replacement> getReplacementsCopy() {
        return new ArrayList<Replacement>(this.replacements);
    }

    public String[] getReplacementRepresentations() {
        String[] ret = new String[this.replacements.size()];
        int i = 0;
        for (Replacement replacement : this.replacements) {
            ret[i++] = replacement.toString();
        }
        return ret;
    }

    public boolean hasReplacementValue(Object originalValue, SourceInfoTaintLabel label) {
        for (Replacement replacement : this.replacements) {
            if (!replacement.isApplicable(originalValue.getClass(), label)) continue;
            return true;
        }
        return false;
    }

    public synchronized <T> T getReplacementValue(T originalValue, SourceInfoTaintLabel label) {
        for (Replacement replacement : this.replacements) {
            T ret;
            if (!replacement.isApplicable(originalValue.getClass(), label) || (ret = replacement.getReplacement(originalValue, label)) == null) continue;
            return ret;
        }
        return originalValue;
    }

    public boolean requiredReplacementsSuccessful() {
        for (Replacement replacement : this.replacements) {
            if (!replacement.isRequired() || replacement.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    public boolean matchesTestInfo(String className, String methodName) {
        return this.testClass.equals(className) && (methodName == null || this.testMethod.equals(methodName));
    }

    public void setTestInfo(String uniqueID, String testClass, String testMethod) {
        this.violationUIDs.clear();
        this.violationUIDs.add(uniqueID);
        this.testClass = testClass;
        this.testMethod = testMethod;
    }

    public void addViolationUniqueIDs(Collection<String> ids) {
        this.violationUIDs.addAll(ids);
    }

    public boolean producesSameRerunBehavior(TestRerunConfiguration other) {
        if (this.testClass == null || this.testMethod == null || other.testClass == null || other.testMethod == null) {
            return false;
        }
        if (!this.testClass.equals(other.testClass) || !this.testMethod.equals(other.testMethod)) {
            return false;
        }
        if (this.autoTainterClass != null && !this.autoTainterClass.equals(other.autoTainterClass) || this.autoTainterClass == null && other.autoTainterClass != null) {
            return false;
        }
        if (this.replacements.size() != other.replacements.size()) {
            return false;
        }
        return this.replacements.equals(other.replacements);
    }

    public int numberOfRequiredReplacements() {
        int count = 0;
        for (Replacement replacement : this.replacements) {
            if (!replacement.isRequired()) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("RerunConfig {").append("\n\tTest: ").append(this.testClass).append('#').append(this.testMethod).append("\n\tAutoTainterClass: ").append(this.autoTainterClass).append("\n\tViolationUIDS: ").append(this.violationUIDs).append("\n\tReplacements: [");
        for (Replacement r : this.replacements) {
            builder.append("\n\t\t").append(r);
        }
        return builder.append("\n\t]\n}").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRerunConfiguration that = (TestRerunConfiguration)o;
        if (this.testClass != null ? !this.testClass.equals(that.testClass) : that.testClass != null) {
            return false;
        }
        if (this.testMethod != null ? !this.testMethod.equals(that.testMethod) : that.testMethod != null) {
            return false;
        }
        if (this.autoTainterClass != null ? !this.autoTainterClass.equals(that.autoTainterClass) : that.autoTainterClass != null) {
            return false;
        }
        if (this.violationUIDs != null ? !this.violationUIDs.equals(that.violationUIDs) : that.violationUIDs != null) {
            return false;
        }
        return this.replacements != null ? this.replacements.equals(that.replacements) : that.replacements == null;
    }

    public int hashCode() {
        int result = this.testClass != null ? this.testClass.hashCode() : 0;
        result = 31 * result + (this.testMethod != null ? this.testMethod.hashCode() : 0);
        result = 31 * result + (this.autoTainterClass != null ? this.autoTainterClass.hashCode() : 0);
        result = 31 * result + (this.violationUIDs != null ? this.violationUIDs.hashCode() : 0);
        result = 31 * result + (this.replacements != null ? this.replacements.hashCode() : 0);
        return result;
    }

    public void resetReplacements() {
        for (Replacement r : this.replacements) {
            r.setSuccessful(false);
        }
    }
}

